-- Create table
create table CON_CONTRACT_IFRS9
(
  ifrs_id                   NUMBER,
  bp_code                   VARCHAR2(30),
  bp_name                   VARCHAR2(100),
  contract_number           VARCHAR2(2000),
  int_rate_display          NUMBER,
  lease_start_date          DATE,
  contract_amount           NUMBER,
  pre_pay_amount            NUMBER,
  contract_principal_amount NUMBER,
  overdue_amount            NUMBER,
  max_overdue_days          NUMBER,
  rest_amount               NUMBER,
  pay_date                  DATE,
  pay_amount                NUMBER,
  industry_belonged         VARCHAR2(1000),
  lease_item_location       VARCHAR2(1000),
  base_date                 DATE,
  created_by                NUMBER default -1,
  creation_date             DATE default SYSDATE,
  last_updated_by           NUMBER default -1,
  last_update_date          DATE default SYSDATE,
  period_day                VARCHAR2(200)
)
tablespace HL_CM_DEV
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
-- Add comments to the columns
comment on column CON_CONTRACT_IFRS9.period_day
  is '期间';
alter table con_contract_ifrs9
  add constraint CON_CONTRACT_IFRS9_PK primary key (ifrs_id);
CREATE SEQUENCE CON_CONTRACT_IFRS9_S;
