package com.hand.hls.hlcm.icbc.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hls.hlcm.icbc.dto.InterfaceRecord;
import com.hand.hls.hlcm.icbc.formbean.*;
import com.hand.hls.hlcm.icbc.mapper.InterfaceRecordMapper;
import com.hand.hls.hlcm.icbc.service.IInitCommandService;
import com.hand.hls.hlcm.icbc.service.IInterfaceRecordService;
import com.hand.hls.hlcm.icbc.utils.DoubleUtil;
import com.hand.hls.hlcm.icbc.utils.IcbcUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @program: hlap-dr-parent
 * @author: huangtianyang
 * @create: 2018-11-14 13:37
 **/
@Service("initCommandServiceImpl")
@Transactional(noRollbackFor = RuntimeException.class)
public class InitCommandServiceImpl implements IInitCommandService {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private InterfaceRecordMapper recordMapper;

    @Autowired
    @Qualifier("interfaceRecordServiceImpl")
    private IInterfaceRecordService recordService;

    @Override
    @SuppressWarnings("unchecked")
    public void initSendCommand(IRequest iRequest, Long batchId, String mode) throws Exception {

        //接口配置信息
        IcbcConfig icbcConfig = recordMapper.getIcbcConfig();
        logger.debug("###icbcConfig is {}###", icbcConfig.toString());

        //批次信息
        List<IcbcCommandBatch> batches = recordMapper.queryCommandBatch(batchId);
        if (CollectionUtils.isEmpty(batches)) {
            logger.error("invalid batchId: {}", batchId);
            throw new Exception("该批次代扣不存在！");
        }
        BankBatch bankBatch = new BankBatch();
        bankBatch.setBatchId(batchId);
        bankBatch.setStatus("POST");
        recordMapper.updateBankBatchStatus(bankBatch);

        //最多100 再多自杀
        List<List> batchGroups = IcbcUtils.groupList(batches, 80);
        for (List<IcbcCommandBatch> batchGroup : batchGroups) {
            SendCommand sendCommand = IcbcUtils.initSendCommand(icbcConfig, batchGroup, mode);
            recordService.submitOrder(iRequest, sendCommand, "submit");
        }

    }

    @Override
    @SuppressWarnings("unchecked")
    public void initQueryCommand(IRequest iRequest, Long batchId) throws Exception {
        IcbcConfig config = recordMapper.getIcbcConfig();
        logger.debug("###icbcConfig is {}###", config.toString());


        InterfaceRecord record = new InterfaceRecord();
        record.setBatchId(batchId);
        List<InterfaceRecord> records = recordMapper.select(record);

        BankBatch bankBatch = new BankBatch();
        bankBatch.setBatchId(batchId);
        bankBatch.setStatus("RETURN");

        for (InterfaceRecord interfaceRecord : records) {
            Long interfaceId = interfaceRecord.getInterfaceId();
            IcbcCommandBatch batch = new IcbcCommandBatch();
            batch.setBatchId(batchId);
            batch.setInterfaceId(interfaceId);

            List<IcbcCommandBatch> batches = recordMapper.queryBatchByInterFaceId(batch);
            if (CollectionUtils.isNotEmpty(batches)) {
                SendCommand sendCommand = IcbcUtils.initQueryCommand(config, interfaceRecord, batches);

                List<IcbcRd> rds = recordService.submitOrder(iRequest, sendCommand, "query");


                if (CollectionUtils.isNotEmpty(rds)) {
                    for (IcbcRd rd : rds) {
                        BankBatchGroupResult result = new BankBatchGroupResult();
                        if ("7".equals(rd.getResult())) {
                            result.setRealAmount(DoubleUtil.div(Double.valueOf(rd.getPayAmt()), 100D, 2));
                        } else {
                            result.setRealAmount(0D);
                        }
                        result.setResCode(rd.getResult());
                        result.setResMsg(rd.getBankRem());
                        result.setGroupId(Long.valueOf(rd.getQryiSeqno()));
                        result.setStatus(IcbcUtils.getGroupStatusByCode(rd.getResult()));
                        result.setBatchId(batchId);
                        result.setInterfaceId(String.valueOf(interfaceId));
                        recordMapper.updateBankBatchResult(result);

                        if ("7".equals(rd.getResult())) {
                            List<Long> contractIds = recordMapper.queryContractIdByGroupId(result.getGroupId());
                            if (CollectionUtils.isNotEmpty(contractIds)) {
                                result.setContractId(contractIds.get(0));
                                recordMapper.sendBankSms(result);
                            }
                        }

                        if (BankBatchGroupResult.STATUS_DEAL
                                .equals(IcbcUtils.getGroupStatusByCode(rd.getResult()))) {
                            bankBatch.setStatus("POST");
                        }

                    }
                }
            }
        }

        BankBatchGroupResult groupResult = new BankBatchGroupResult();
        groupResult.setBatchId(batchId);
//        List<Long> successes = recordMapper.queryBeforeTransaction(batchId);
//        if (CollectionUtils.isNotEmpty(successes)) {
            //调用包中的函数
        try {
            recordMapper.hlsCreateTransaction(groupResult);
        }catch (Exception e){
            logger.error("核销报错:", e);
        }
//        }
        recordMapper.updateBatchStatusWithOutDate(bankBatch);


    }
}
