package com.hand.hls.hlcm.hls.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.hls.dto.HlsMaster;
import com.hand.hls.hlcm.hls.service.HlsMasterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;

@Controller
public class HlsMasterController extends BaseController {

    @Autowired
    private HlsMasterService service;


    @RequestMapping(value = "/hls/template/query")
    @ResponseBody
    public ResponseData query(HlsMaster dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {

        IRequest requestContext = createRequestContext(request);

        ResponseData responseData = new ResponseData();

        HashMap<String, Object> hm = new HashMap<>();
        hm.put("tplNo", "F01");

        try{
            List<HashMap<String, Object>> list = service.selectTemplateList(hm);
            responseData = new ResponseData(list);
            responseData.setSuccess(true);
        }catch (Exception e){
            e.printStackTrace();
            responseData.setMessage("System Error");
            responseData.setSuccess(false);
        }
        return responseData;
    }


    @RequestMapping(value = "/hls/template/detail/list")
    @ResponseBody
    public ResponseData hlsTemplateDetailList(@RequestBody HlsMaster dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {

        IRequest requestContext = createRequestContext(request);
        System.out.println("hlsTemplateDetailList ： " + dto);
        ResponseData responseData = new ResponseData();

        String sch_tpl_no = null != dto.getTplNo() ? dto.getTplNo() : "";
        String sch_dtl_div = null != dto.getDtlDiv() ? dto.getDtlDiv() : "";

        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("sch_tpl_no", sch_tpl_no);
        hm.put("sch_dtl_div", sch_dtl_div);

        try{
            List<HashMap<String, Object>> list = service.selectTemplateDetailList(hm);
            responseData = new ResponseData(list);
            responseData.setSuccess(true);
        }catch (Exception e){
            e.printStackTrace();
            responseData.setMessage("System Error");
            responseData.setSuccess(false);
        }
        return responseData;
    }


    @RequestMapping(value = "/hls/template/detail/info")
    @ResponseBody
    public ResponseData hlsTemplateDetailInfo(@RequestBody HlsMaster dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {

        IRequest requestContext = createRequestContext(request);
        System.out.println("hlsTemplateDetailInfo");
        ResponseData responseData = new ResponseData();

        String sch_tpl_no = null != dto.getTplNo() ? dto.getTplNo() : "";
        String sch_dtl_div = null != dto.getDtlDiv() ? dto.getDtlDiv() : "";
        int sch_dtl_no = 0 > dto.getDtlNo() ? dto.getDtlNo() : 0;

        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("sch_tpl_no", sch_tpl_no);
        hm.put("sch_dtl_div", sch_dtl_div);
        hm.put("sch_dtl_no", sch_dtl_no);

        try{
            List<HashMap<String, Object>> info = service.selectTemplateDetailInfo(hm);
            responseData = new ResponseData(info);
            responseData.setSuccess(true);
        }catch (Exception e){
            e.printStackTrace();
            responseData.setMessage("System Error");
            responseData.setSuccess(false);
        }
        return responseData;
    }


    @RequestMapping(value = "/hls/template/detail/submit")
    @ResponseBody
    public ResponseData hlsTemplateDetailSubmit(@RequestBody List<HlsMaster> dto,HttpServletRequest request) {

        IRequest requestContext = createRequestContext(request);
        System.out.println("hlsTemplateDetailSubmit ：" + dto.size());

        ResponseData responseData = new ResponseData();

        HashMap<String, Object> hm;

        try{
            int result = 0;

            if(dto.size() >0){
                for(int i=0; i < dto.size(); i++){
                    hm = new HashMap<String, Object>();
                    hm.put("inp_tpl_no", dto.get(i).getTplNo());
                    hm.put("inp_dtl_div", dto.get(i).getDtlDiv());
                    hm.put("inp_dtl_no", dto.get(i).getDtlNo());
                    hm.put("inp_approve_div", dto.get(i).getApproveDiv());
                    hm.put("inp_approve_val", dto.get(i).getApproveVal());
                    hm.put("inp_approve_tp", dto.get(i).getApproveTp());
                    result += service.updateTemplateDetail(hm);
                }
            }
            responseData = new ResponseData();

            if(result > 0){
                responseData.setSuccess(true);
            }else{
                responseData.setSuccess(false);
                responseData.setMessage("Not Updated Template Info");
            }

        }catch (Exception e){
            e.printStackTrace();
            responseData.setMessage("System Error");
            responseData.setSuccess(false);
        }
        return responseData;
    }

}