/*
 * Decompiled with CFR 0.152.
 */
package com.jacob.com;

import com.jacob.com.JacobObject;
import com.jacob.com.JacobReleaseInfo;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class LibraryLoader {
    public static final String JACOB_DLL_PATH = "jacob.dll.path";
    public static final String JACOB_DLL_NAME = "jacob.dll.name";
    public static final String JACOB_DLL_NAME_X86 = "jacob.dll.name.x86";
    public static final String JACOB_DLL_NAME_X64 = "jacob.dll.name.x64";
    public static final String DLL_NAME_MODIFIER_32_BIT = "x86";
    public static final String DLL_NAME_MODIFIER_64_BIT = "x64";

    public static void loadJacobLibrary() {
        String path;
        ResourceBundle resources = null;
        HashSet<String> keys = new HashSet<String>();
        try {
            resources = ResourceBundle.getBundle(LibraryLoader.class.getName(), Locale.getDefault(), LibraryLoader.class.getClassLoader());
            Enumeration<String> i = resources.getKeys();
            while (i.hasMoreElements()) {
                String key = i.nextElement();
                keys.add(key);
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if ((path = System.getProperty(JACOB_DLL_PATH)) == null && resources != null && keys.contains(JACOB_DLL_PATH)) {
            path = (String)resources.getObject(JACOB_DLL_PATH);
        }
        if (path != null) {
            JacobObject.debug("Loading library " + path + " using System.loadLibrary ");
            System.load(path);
        } else {
            String name = null;
            name = System.getProperty(JACOB_DLL_NAME) != null ? System.getProperty(JACOB_DLL_NAME) : (System.getProperty(JACOB_DLL_NAME_X86) != null && LibraryLoader.shouldLoad32Bit() ? System.getProperty(JACOB_DLL_NAME_X86) : (System.getProperty(JACOB_DLL_NAME_X64) != null && !LibraryLoader.shouldLoad32Bit() ? System.getProperty(JACOB_DLL_NAME_X64) : (resources != null && keys.contains(JACOB_DLL_NAME) ? resources.getString(JACOB_DLL_NAME) : (resources != null && keys.contains(JACOB_DLL_NAME_X86) && LibraryLoader.shouldLoad32Bit() ? resources.getString(JACOB_DLL_NAME_X86) : (resources != null && keys.contains(JACOB_DLL_NAME_X64) && !LibraryLoader.shouldLoad32Bit() ? resources.getString(JACOB_DLL_NAME_X64) : LibraryLoader.getPreferredDLLName())))));
            JacobObject.debug("Loading library " + name + " using System.loadLibrary ");
            System.loadLibrary(name);
        }
    }

    public static String getPreferredDLLName() {
        if (LibraryLoader.shouldLoad32Bit()) {
            return "jacob-" + JacobReleaseInfo.getBuildVersion() + "-" + DLL_NAME_MODIFIER_32_BIT;
        }
        return "jacob-" + JacobReleaseInfo.getBuildVersion() + "-" + DLL_NAME_MODIFIER_64_BIT;
    }

    protected static boolean shouldLoad32Bit() {
        String bits = System.getProperty("sun.arch.data.model", "?");
        if (bits.equals("32")) {
            return true;
        }
        if (bits.equals("64")) {
            return false;
        }
        String arch = System.getProperty("java.vm.name", "?");
        return arch.toLowerCase().indexOf("64-bit") < 0;
    }
}

