var override_queryfields = [
    {
        name: 'tax_type_rate',
        queryexpression: "t1.tax_type_rate=${@tax_type_rate}"
    },

    {
        name: 'accounting_date_from',
        queryexpression: "t1.accounting_date>=trunc(to_date(${@accounting_date_from},'yyyy-mm-dd'))"
    },
    {
        name: 'accounting_date_to',
        queryexpression: "trunc(t1.accounting_date) <= to_date(${@accounting_date_to},'yyyy-mm-dd')"
    },


    {
        name: 'invoice_date_from',
        queryexpression: "t1.invoice_date between to_date(${@invoice_date_from},'yyyy-mm-dd') and nvl(to_date(${@invoice_date_to},'yyyy-mm-dd'),t1.invoice_date)"
    },
    {
        name: 'invoice_date_to',
        queryexpression: "t1.invoice_date between nvl(to_date(${@invoice_date_from},'yyyy-mm-dd'),t1.invoice_date) and to_date(${@invoice_date_to},'yyyy-mm-dd')"
    },
    {
        name: 'invoice_number_from',
        queryexpression: "t1.invoice_number >=  ${@invoice_number_from} "
    },
    {
        name: 'invoice_number_to',
        queryexpression: "t1.invoice_number <=  ${@invoice_number_to} "
    },
    {
        name: 'contract_number_from',
        queryexpression: "t1.contract_number >=  ${@contract_number_from} "
    },
    {
        name: 'contract_number_to',
        queryexpression: "t1.contract_number <=  ${@contract_number_to} "
    }

];

var add_datafilters = [
    {
        name:'authority_flag',
        expression : "(exists (SELECT 1\n" +
            "                  FROM hls_bp_master        hm,\n" +
            "                       exp_org_unit         u,\n" +
            "                       exp_org_position     op,\n" +
            "                       exp_employee_assigns ea,\n" +
            "                       sys_user             su\n" +
            "                 where hm.unit_id = u.unit_id\n" +
            "                   and u.unit_id = op.unit_id\n" +
            "                   and ea.position_id = op.position_id\n" +
            "                   and ea.employee_id = su.employee_id\n" +
            "                   and hm.bp_id = t1.bp_agent_id\n" +
            "                   and su.user_id = ${/session/@user_id}) or\n" +
            "        exists(SELECT 1\n" +
            "                  FROM sys_role sr\n" +
            "                 WHERE sr.role_id =${/session/@role_id}\n" +
            "                   and sr.role_code in ('0017', 'HAND'))  or exists (select 1\n" +
            "                   from exp_employees ee, exp_employee_types et,sys_user us\n" +
            "                  where ee.employee_id = us.employee_id\n" +
            "                    and ee.employee_type_id = et.employee_type_id\n" +
            "                    and et.employee_type_code = 'STAFF'\n" +
            "                    and us.user_id = ${/session/@user_id}))"
    }
];

override();
add_datafilter();
