package com.hand.hls.hlcm.acr.dto;

import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.system.dto.BaseDTO;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * @Author Robert8900
 * @Date: 2018/8/29 13:36
 * @Description: 电子发票中间头表
 * @Purpose:
 **/
@ExtensionAttribute(disable = true)
@Table(name = "acr_ele_invoice_hd")
public class AcrEleInvoiceHd extends BaseDTO {
    @Id
    @GeneratedValue
    private Long eleInvoiceHdId;  //电子发票头ID/PK
    private Long invoiceHdId;     //发票表头ID
    private String documentType;  //单据类型
    private String documentCategory;  //单据类别
    private String swno;    //流水号
    private String saleTax;   //销方税号
    private String custName;   //购方名称
    private String custTaxNo;   //购方税号
    private String custAddr;    //购方地址
    private String custTelephone;   //购货方手机号
    private String custPhone;   //购方固定电话
    private String custEmail;   //购方邮箱
    private String custBankAccount;   //开户行+账号
    private String custType;    //购货方企业类型
    private String invoMemo;    //备注
    private String invType;     //发票类型
    private Date billDate;   //发票类型
    private String thdh;     //退货单位
    private Long billType; //开票类型
    private String specialRedFlag;   //特殊红冲标志
    private String operationCode;   //操作代码
    private String kpy;  //开票人
    private String sky;  //收款员
    private String fhr; //复核人
    private String yfpdm; //原发票代码
    private String yfphm; //原发票号码
    private String chyy;  //红冲原因
    private String status; //电子发票状态
    private String pdfUrl; //电子接口返回的pdf附件URL
    private String errorCode; //电子发票返回错误code
    private String errorMessage; //电子发票返回错误message

    @Transient
    private Long cashflowId;
    @Transient
    private Long cfType;
    //发票余量
    @Transient
    private int acrEleNumber;
    @Transient
    private Long companyId;

    public Long getEleInvoiceHdId() {
        return eleInvoiceHdId;
    }

    public void setEleInvoiceHdId(Long eleInvoiceHdId) {
        this.eleInvoiceHdId = eleInvoiceHdId;
    }

    public Long getInvoiceHdId() {
        return invoiceHdId;
    }

    public void setInvoiceHdId(Long invoiceHdId) {
        this.invoiceHdId = invoiceHdId;
    }

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocumentCategory() {
        return documentCategory;
    }

    public void setDocumentCategory(String documentCategory) {
        this.documentCategory = documentCategory;
    }

    public String getSwno() {
        return swno;
    }

    public void setSwno(String swno) {
        this.swno = swno;
    }

    public String getSaleTax() {
        return saleTax;
    }

    public void setSaleTax(String saleTax) {
        this.saleTax = saleTax;
    }

    public String getCustName() {
        return custName;
    }

    public void setCustName(String custName) {
        this.custName = custName;
    }

    public String getCustTaxNo() {
        return custTaxNo;
    }

    public void setCustTaxNo(String custTaxNo) {
        this.custTaxNo = custTaxNo;
    }

    public String getCustAddr() {
        return custAddr;
    }

    public void setCustAddr(String custAddr) {
        this.custAddr = custAddr;
    }

    public String getCustTelephone() {
        return custTelephone;
    }

    public void setCustTelephone(String custTelephone) {
        this.custTelephone = custTelephone;
    }

    public String getCustPhone() {
        return custPhone;
    }

    public void setCustPhone(String custPhone) {
        this.custPhone = custPhone;
    }

    public String getCustEmail() {
        return custEmail;
    }

    public void setCustEmail(String custEmail) {
        this.custEmail = custEmail;
    }

    public String getCustBankAccount() {
        return custBankAccount;
    }

    public void setCustBankAccount(String custBankAccount) {
        this.custBankAccount = custBankAccount;
    }

    public String getCustType() {
        return custType;
    }

    public void setCustType(String custType) {
        this.custType = custType;
    }

    public String getInvoMemo() {
        return invoMemo;
    }

    public void setInvoMemo(String invoMemo) {
        this.invoMemo = invoMemo;
    }

    public String getInvType() {
        return invType;
    }

    public void setInvType(String invType) {
        this.invType = invType;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getThdh() {
        return thdh;
    }

    public void setThdh(String thdh) {
        this.thdh = thdh;
    }

    public Long getBillType() {
        return billType;
    }

    public void setBillType(Long billType) {
        this.billType = billType;
    }

    public String getSpecialRedFlag() {
        return specialRedFlag;
    }

    public void setSpecialRedFlag(String specialRedFlag) {
        this.specialRedFlag = specialRedFlag;
    }

    public String getOperationCode() {
        return operationCode;
    }

    public void setOperationCode(String operationCode) {
        this.operationCode = operationCode;
    }

    public String getKpy() {
        return kpy;
    }

    public void setKpy(String kpy) {
        this.kpy = kpy;
    }

    public String getSky() {
        return sky;
    }

    public void setSky(String sky) {
        this.sky = sky;
    }

    public String getFhr() {
        return fhr;
    }

    public void setFhr(String fhr) {
        this.fhr = fhr;
    }

    public String getYfpdm() {
        return yfpdm;
    }

    public void setYfpdm(String yfpdm) {
        this.yfpdm = yfpdm;
    }

    public String getYfphm() {
        return yfphm;
    }

    public void setYfphm(String yfphm) {
        this.yfphm = yfphm;
    }

    public String getChyy() {
        return chyy;
    }

    public void setChyy(String chyy) {
        this.chyy = chyy;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    public Long getCashflowId() {
        return cashflowId;
    }

    public void setCashflowId(Long cashflowId) {
        this.cashflowId = cashflowId;
    }

    public Long getCfType() {
        return cfType;
    }

    public void setCfType(Long cfType) {
        this.cfType = cfType;
    }



    public int getAcrEleNumber() {
        return acrEleNumber;
    }

    public void setAcrEleNumber(int acrEleNumber) {
        this.acrEleNumber = acrEleNumber;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getPdfUrl() {
        return pdfUrl;
    }

    public void setPdfUrl(String pdfUrl) {
        this.pdfUrl = pdfUrl;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
