package com.hand.hls.hlcm.txtftp.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.hls.service.HlsInterfaceLogService;
import com.hand.hls.hlcm.txtftp.formbean.TrancationData;
import com.hand.hls.hlcm.txtftp.mapper.PosTxtUploadMapper;
import com.hand.hls.hlcm.txtftp.service.PosTxtUploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

@Service
@Transactional(rollbackFor = Exception.class)
public class PosTxtUploadServiceImpl implements PosTxtUploadService {
    @Autowired
    HlsInterfaceLogService hlsInterfaceLogService;
    @Autowired
    PosTxtUploadMapper posTxtUploadMapper;

    @Override
    public ResponseData createTransactionByPosTxt(IRequest iRequest, MultipartFile file) throws IOException {
        ResponseData responseData = new ResponseData();

        InputStream inputStream = file.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));

        StringBuilder sb = new StringBuilder();
        String line = null;
        List<TrancationData> trancationDataList = new ArrayList<>();
        try {
            while ((line = reader.readLine()) != null) {

                //根据tab 切割
                TrancationData trancationData = new TrancationData();
                String[] segments = line.split("\t"); //按tab分割

                trancationData.setBpBankAccountNum(segments[3]);

                trancationData.setTerminalNumber(segments[1]);

                trancationData.setInternalPeriodNum(Long.parseLong(segments[4].substring(0, 6)));
                trancationData.setPeriodName(segments[4].substring(0, 4) + '-' + segments[4].substring(4, 6));
                //SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                //trancationData.setTrancationDate(sdf.parse(segments[4]));
                trancationData.setTrancationDate(segments[4]);
                Double handlingFeeAmount = Double.parseDouble(segments[7]);
                Double creditCardAmount = Double.parseDouble(segments[6]);
                Double trancationAmount = Double.parseDouble(segments[8]);

                trancationData.setHandlingFeeAmount(handlingFeeAmount);
                trancationData.setCreditCardAmount(creditCardAmount);

                if (handlingFeeAmount.compareTo(20.0) == 1) {
                    trancationData.setTransactionAmount(trancationAmount);
                } else {
                    trancationData.setTransactionAmount(creditCardAmount);
                }
//                if (segments[17] == null || ("").equals(segments[17])) {
//                    responseData.setSuccess(false);
//                    responseData.setMessage("会员号不能为空！");
//                    return responseData;
//
//                }
                trancationData.setContractNumber(segments[17]);
                trancationData.setUserCode(segments[15]);

                trancationData.setUserId(iRequest.getUserId());
                trancationData.setCompanyId(iRequest.getCompanyId());
                //posTxtUploadMapper.createTrancation(trancationData);
                //改为bm调用 方便看到错误提示
                //posTxtUploadMapper.createTrancationAndWriteOff(trancationData);
                trancationDataList.add(trancationData);
            }

        } catch (IOException e) {
            e.printStackTrace();
        }/* catch (ParseException e) {
            e.printStackTrace();
        }*/ catch (Exception e) {
            responseData.setSuccess(false);
            responseData.setMessage("导入出错，请联系管理员");
            return responseData;
        } finally {
            try {
                inputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        responseData.setSuccess(true);
        responseData.setRows(trancationDataList);
        responseData.setMessage("导入成功");
        return responseData;
    }
}