/**
 *[组件-HlsSelectBar]
 */
function HlsSelectBar() {

}

hlsExtend(HlsSelectBar, HlsConponentBase);

HlsSelectBar.prototype._init = function (opt) {
    this.opt = {};
    $jq.extend(true, this.opt, opt || {});
    this.renderUI();
}

HlsSelectBar.prototype.renderUI = function () {
    console.log(this.opt);
    var items = this.opt.items;
    var appendHtml = '';
    if (items) {
        for (var i = 0; i < items.length; i++) {
            appendHtml += '<li>';
            appendHtml += '<div onclick="' + items[i].click + '(event)"  class="contain" >';
            appendHtml += '<img id = "' + items[i].imgId + '" height="30" width="30" style="margin-top:5px;" ';
            appendHtml += 'src = " ' + items[i].img + ' " /> ';
            appendHtml += '<div id = " ' + items[i].textId + ' " class="text-content-right" style="background-color: ' + items[i].color + ' ;"> ';
            appendHtml += items[i].description;
            appendHtml += '</div>';
            appendHtml += '</div>';
            appendHtml += '</li>';
        }
    }
    $jq("#" + this.opt.id + " ul").html(appendHtml);
}

/****************************************** 组件-HlsSelectBar END **************************************/

/**
 *[组件-HlsTab]
 */
function HlsTab() {

}

hlsExtend(HlsTab, HlsConponentBase);

HlsTab.prototype._init = function (opt) {
    var contextPath = opt.contextPath;
    this.opt = {};
    $jq.extend(true, this.opt, opt || {});
    this.settingParamMap();
    this.renderUI();
}

HlsTab.prototype.renderUI = function () {
    var items = this.opt.items;
    var appendHtml = '';
    if (items) {
        var width = Math.floor(100 / items.length) + '%';
        for (var i = 0; i < items.length; i++) {
            appendHtml += '<li onclick="' + items[i].click + '(event)"  style="width:' + width + ';" id="item' + i + '" >';
            appendHtml += items[i].description;
            appendHtml += '</li>';
        }
        console.log(appendHtml);
    }
    $jq("#hlsTab")[0].innerHTML = appendHtml;

    var liWidth = $jq('#' + this.opt.id + ' ul li').eq(0).width();
    $jq('.tab ul li').hover(function () {
        $jq('.curline').stop();
        var liIndex = $jq(this).index();
        $jq('.curline').animate({
            left: liWidth * liIndex + 'px'
        });
    })

}
/****************************************** 组件-HlsTab END **************************************/

/*
 [HlsQueryTab组件 ]
 */
function HlsQueryTab() {

}

hlsExtend(HlsQueryTab, HlsConponentBase);
$jq.extend(HlsQueryTab.prototype, {
    _init: function (opt) {
        this.opt = {
            suggestMaxHeight: '200px',//弹出框最大高度
            itemColor: '#000000',//默认字体颜色
            itemBackgroundColor: 'RGB(255,255,255)',//默认背景颜色
            itemOverColor: '#ffffff',//选中字体颜色
            itemOverBackgroundColor: '#C9302C',//选中背景颜色
            itemPadding: 3,//item间距
            fontSize: 12,//默认字体大小
            alwaysShowALL: false //点击input是否展示所有可选项
        }
        $jq.extend(true, this.opt, opt || {});
        this.renderUI();
    },
    renderUI: function () {
        var data = new Array();
        var opt = this.opt;
        var maxFontNumber = 0;//最大字数
        var currentItem;
        var showClickTextFunction = this.showClickTextFunction;
        var inputChange = this.inputChange;
        var dataSource = inputChange(opt);
        var suggestContainerId = opt.id + "_testInput" + "-suggest";
        var suggestContainerWidth = $jq('#' + opt.id + "_testInput").innerWidth();
        var suggestContainerLeft = $jq('#' + opt.id + "_testInput").offset().left;
        var suggestContainerTop = $jq('#' + opt.id + "_testInput").offset().top + $jq('#' + opt.id + "_testInput").outerHeight();
        var suggestContainer;
        if ($jq('#' + suggestContainerId)[0]) {
            suggestContainer = $jq('#' + suggestContainerId);
            suggestContainer.empty();
        } else {
            suggestContainer = $jq('<div></div>'); //创建一个子<div>
        }

        suggestContainer.attr('id', suggestContainerId);
        suggestContainer.attr('tabindex', '0');
        suggestContainer.hide();
        var _initItems = function (items) {
            suggestContainer.empty();
            for (var i = 0; i < items.length; i++) {
                if (items[i].text.length > maxFontNumber) {
                    maxFontNumber = items[i].text.length;
                }
                var suggestItem = $jq('<div></div>'); //创建一个子<div>

                var inputValue = $jq('#' + opt.id + "_testInput").val();
                inputValue = inputValue.replace(/[\-\[\]{}()*+?.,\\\^$jq|#\s]/g, "\\$jq&");
                var reg = new RegExp(inputValue + '');
                if (items[i].text.match(reg) != null) {
                    suggestItem.attr('id', items[i].id);
                    suggestItem.append(items[i].text);
                    suggestItem.css({
                        'padding': opt.itemPadding + 'px',
                        'white-space': 'nowrap',
                        'cursor': 'pointer',
                        'background-color': opt.itemBackgroundColor,
                        'color': opt.itemColor
                    });
                    suggestItem.bind("mouseover",
                        function () {
                            $jq(this).css({
                                'background-color': opt.itemOverBackgroundColor,
                                'color': opt.itemOverColor
                            });
                            currentItem = $jq(this);
                        });
                    suggestItem.bind("mouseout",
                        function () {
                            $jq(this).css({
                                'background-color': opt.itemBackgroundColor,
                                'color': opt.itemColor
                            });
                            currentItem = null;
                        });
                    suggestItem.bind("click", {
                        'opt': opt,
                        'currentItem': currentItem,
                        'suggestContainerId': suggestContainerId
                    }, showClickTextFunction);
                    suggestItem.bind("click", opt.itemSelectFunction);
                    suggestItem.appendTo(suggestContainer);
                    var a = document.getElementById(opt.id + "_query");
                    suggestContainer.appendTo(a);
                }

            }
        }


        $jq('#' + opt.id + "_testInput").bind("keyup",
            function () {
                _initItems(dataSource);
            });
        // $jq('#' + opt.id +"_testInput").bind("blur",
        //     function() {
        //         if(!$jq('#' + suggestContainerId).is(":focus")){
        //
        //             $jq('#' + suggestContainerId).hide();
        //             if (currentItem) {
        //                 currentItem.trigger("click");
        //             }
        //             currentItem = null;
        //             return;
        //         }
        //     });
        $jq('#' + opt.id + "_testInput").bind("click",
            function () {
                if (opt.alwaysShowALL) {
                    _initItems(data);
                } else {
                    _initItems(dataSource);
                }
                $jq('#' + suggestContainerId).removeAttr("style");
                $jq('#' + suggestContainerId).css({
                    'border': '1px solid #ccc',
                    'height': '190px',
                    'top': '50px',
                    'left': '0px',
                    'width': '270px',
                    'position': 'absolute',
                    'font-size': opt.fontSize + 'px',
                    'font-family': 'Arial',
                    'z-index': 99999,
                    'background-color': '#FFFFFF',
                    'overflow-y': 'auto',
                    'overflow-x': 'hidden',
                    'white-space': 'nowrap',
                    "box-shadow": '3px 3px 3px rgb(204,204,204)',
                    "border-radius": '5px',
                    "overflow": 'auto'

                });
                $jq('#' + suggestContainerId).show();
            });
        _initItems(data);

        // $jq('#' + suggestContainerId).bind("blur",
        //     function() {
        //         $jq('#' + suggestContainerId).hide();
        //     });

        // $jq('#' + suggestContainerId).live("blur",function () {
        //     $jq(this).hidden();
        // });
        $jq(document).on("mouseleave", "#" + suggestContainerId, function (e) {
            if (e.target.id != suggestContainerId) {
                $jq("#" + suggestContainerId).hide();
            }
        });
        /*$jq(document).click(function(e){

        });*/

    },
    showClickTextFunction: function (e) {
        $jq('#' + e.data.opt.id + "_testInput").val(this.innerText);
        e.data.currentItem = null;
        $jq('#' + e.data.suggestContainerId).hide();
    },
    inputChange: function (opt) {


        var rows = new Array();
        $jq.ajax({
            type: 'GET',
            url: opt.url,
            async: false, //设为同步
            contentType: "application/json; charset=utf-8",
            success: function (datas) {
                var qId = opt.queryId;
                var qText = opt.queryText;
                datas = HlsQueryTab.prototype.getAjaxResult(datas);

                for (var i = 0; i < datas.length; i++) {
                    rows[i] = new Object();
                    rows[i].id = datas[i][qId];
                    rows[i].text = datas[i][qText];
                }
            }
        });
        return rows;

    }
});
/****************************************** 组件-HlsQueryTab END **************************************/