/**
 * Created by hty on 2018/5/24.
 */
var conColorMapStatus = {
    "新建": "#2EC3E8",
    "签约": "#14A9CC",
    "取消": "#FA6A4D",
    "起租": "#A0D469",
    "暂挂": "#FFCD55",
    "结束": "#E75B8D"
};
var statusInfo = {
    "NEW": "#2EC3E8",
    "APPROVING": "#FFCD55",
    "CANCEL": "rgb(0,179,179)",
    "APPROVED_RETURN": "#E75B8D",
    "REJECTED": "#FA6A4D",
    "APPROVED": "#A0D469"
};

function renderCon(domId, url, contextPath, para) {
    if (!para) {
        para = {page: 1, pageSize: 5};
    }
    if (window[domId + 'Count'] === undefined) {
        Leaf.request({
            url: url,
            scope: this,
            sync: true,
            success: function (res) {
                if (res.result.record) {
                    window[domId + 'Count'] = Math.ceil(res.result.record.length / para.pageSize);
                }
            }
        })
    }
    var html = '';
    var pageSet;


    pageSet = '?pagenum=' + para.page + '&pageSize=' + para.pageSize;

    Leaf.request({
        url: url + pageSet,
        scope: this,
        success: function (res) {
            var html = '<div id="' + domId + 'Grid" class="grid-class">' +
                '<table style="width: 100%;"><tr>' +
                '<th>合同编号/名称</th>' +
                '<th>承租人</th>' +
                '<th>合同类型</th>' +
                '<th>融资额</th>' +
                '<th>合同状态</th></tr>';
            if (res.result.record) {
                res.result.record.forEach(function (value) {
                    var bgColor = conColorMapStatus[value.contract_status_desc] || "#00b3b3";
                    html += '<tr><td><div>' + value.contract_number + '</div>' +
                        '<div style="color:#9f9f9f;">' + value.contract_name + '</div></td>' +
                        '<td>' + value.bp_name + '</td>' +
                        '<td>' + value.document_type_desc + '</td>' +
                        '<td>' + formatCurrency(value.finance_amount) + '</td>' +
                        '<td><span style="width:60px;height: 20px;line-height: 20px; border-radius: ' +
                        '2px;max-height:32px;text-align:center;color:#fff;display:inline-block;overflow:hidden;background: ' +
                        bgColor + '">' + value.contract_status_desc + '</span></td></tr>';
                });

                html += '</table>' +
                    '<div id="' + domId + '-foot" style="margin: auto;" class="super-grid-footbar">' +
                    '<div class="super-grid-footbtn" style="position: relative;top: 24px;">';
                if (para.page == 1) {
                    html += '<img src="' + contextPath + '/images/home_page/last.png" ';
                } else {
                    html += '<img src="' + contextPath + '/images/home_page/lastCan.png" ';
                }
                html += 'width="15" height="15" onclick="prePage(\'' + domId + '\',\'' + url + '\',\'' + contextPath + '\',' + para.page + ')">' +
                    '<span>' + para.page + '/' + window[domId + 'Count'] + '</span>';
                if (para.page != window[domId + 'Count']) {
                    html += '<img src="' + contextPath + '/images/home_page/nextCan.png" ';
                } else {
                    html += '<img src="' + contextPath + '/images/home_page/nextNot.png" ';
                }
                html += 'width="15" height="15" onclick="nextPage(\'' + domId + '\',\'' + url + '\',\'' + contextPath + '\',' + para.page + ')"></div></div>';

            }
            document.getElementById(domId).innerHTML = html;

        }
    })
}

function prePage(dom, url, contextPath, page) {
    page != 1 && renderCon(dom, url, contextPath, {page: page - 1, pageSize: 5});
}

function nextPage(dom, url, contextPath, page) {
    page != window[dom + 'Count'] && renderCon(dom, url, contextPath, {page: page + 1, pageSize: 5});
}

function renderPrj(domId, url, contextPath, para) {
    if (!para) {
        para = {page: 1, pageSize: 5};
    }
    if (window[domId + 'Count'] === undefined) {
        Leaf.request({
            url: url,
            scope: this,
            sync: true,
            success: function (res) {
                if (res.result.record) {
                    window[domId + 'Count'] = Math.ceil(res.result.record.length / para.pageSize);
                }
            }
        })
    }
    var html = '';
    var pageSet;


    pageSet = '?pagenum=' + para.page + '&pageSize=' + para.pageSize;

    Leaf.request({
        url: url + pageSet,
        scope: this,
        success: function (res) {
            var html = '<div id="' + domId + 'Grid" class="grid-class">' +
                '<table style="width: 100%;"><tr>' +
                '<th>项目编号/名称</th>' +
                '<th>承租人</th>' +
                '<th>项目类型</th>' +
                '<th>项目状态</th></tr>';
            if (res.result.record) {
                res.result.record.forEach(function (value) {
                    var color = statusInfo[value.project_status] || '#00b3b3';
                    html += '<tr><td><div>' + value.project_number + '</div>' +
                        '<div style="color:#9f9f9f;">' + value.project_name + '</div></td>' +
                        '<td>' + value.bp_name + '</td>' +
                        '<td>' + value.document_type_desc + '</td>' +
                        // '<td>' + formatCurrency(value.finance_amount) + '</td>' +
                        '<td><span style="width:60px;height: 20px;line-height: 20px; border-radius: ' +
                        '2px;max-height:32px;text-align:center;color:#fff;display:inline-block;overflow:hidden;background: ' +
                        color + '">' + value.project_status_desc + '</span></div></td></tr>';
                });

                html += '</table>' +
                    '<div id="' + domId + '-foot" style="margin: auto;" class="super-grid-footbar">' +
                    '<div class="super-grid-footbtn" style="position: relative;top: 24px;">';
                if (para.page == 1) {
                    html += '<img src="' + contextPath + '/images/home_page/last.png" ';
                } else {
                    html += '<img src="' + contextPath + '/images/home_page/lastCan.png" ';
                }
                html += 'width="15" height="15" onclick="prePrjPage(\'' + domId + '\',\'' + url + '\',\'' + contextPath + '\',' + para.page + ')">' +
                    '<span>' + para.page + '/' + window[domId + 'Count'] + '</span>';
                if (para.page != window[domId + 'Count']) {
                    html += '<img src="' + contextPath + '/images/home_page/nextCan.png" ';
                } else {
                    html += '<img src="' + contextPath + '/images/home_page/nextNot.png" ';
                }
                html += 'width="15" height="15" onclick="nextPrjPage(\'' + domId + '\',\'' + url + '\',\'' + contextPath + '\',' + para.page + ')"></div></div>';

            }
            document.getElementById(domId).innerHTML = html;

        }
    })
}

function prePrjPage(domId, url, contextPath, page) {
    page != 1 && renderPrj(domId, url, contextPath, {page: page - 1, pageSize: 5});
}

function nextPrjPage(domId, url, contextPath, page) {
    page != window[domId + 'Count'] && renderPrj(domId, url, contextPath, {page: page + 1, pageSize: 5});
}