package com.hand.hls.hlcm.icbc.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.icbc.dto.InterfaceRecord;
import com.hand.hls.hlcm.icbc.formbean.*;
import com.hand.hls.hlcm.icbc.job.IcbcInterfaceJob;
import com.hand.hls.hlcm.icbc.mapper.InterfaceRecordMapper;
import com.hand.hls.hlcm.icbc.service.IInitCommandService;
import com.hand.hls.hlcm.icbc.service.IInterfaceRecordService;
import com.hand.hls.hlcm.icbc.utils.IcbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Controller
public class InterfaceRecordController extends BaseController {

    @Autowired
    @Qualifier("interfaceRecordServiceImpl")
    private IInterfaceRecordService service;

    @Autowired
    @Qualifier("initWithHoldCommandServiceImpl")
    private IInitCommandService initWithHoldCommandService;

    @Autowired
    @Qualifier("initCommandServiceImpl")
    private IInitCommandService initCommandService;

    @Autowired
    private InterfaceRecordMapper recordMapper;



    Logger logger = LoggerFactory.getLogger(getClass());


    @RequestMapping(value = "/icbc/interface/record/query")
    @ResponseBody
    public ResponseData query(InterfaceRecord dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/icbc/interface/record/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<InterfaceRecord> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/icbc/interface/record/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<InterfaceRecord> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value = "/icbc/interface/record/submitorder", method = RequestMethod.POST)
    @ResponseBody
    public ResponseData submitOrder(HttpServletRequest request, @RequestParam Long batchId,
                                    @RequestParam String mode) {
        IRequest iRequest = createRequestContext(request);
        ResponseData responseData = new ResponseData();
        try {
            initCommandService.initSendCommand(iRequest, batchId, mode);
        } catch (Exception e) {
            logger.error("\n submit failed:{}", e);
            responseData.setSuccess(false);
            responseData.setMessage(e.getMessage());
            BankBatch bankBatch = new BankBatch();
            bankBatch.setBatchId(batchId);
            bankBatch.setStatus("POST_FAIL");
            recordMapper.updateBankBatchStatus(bankBatch);
        }
        return responseData;
    }

    @RequestMapping(value = "/icbc/interface/record/queryorder", method = RequestMethod.POST)
    @ResponseBody
    public ResponseData queryOrder(HttpServletRequest request, @RequestParam Long batchId) {
        IRequest iRequest = createRequestContext(request);
        ResponseData responseData = new ResponseData();
        try {
//            List<Long> batchIds = recordMapper.queryUnfullWrittenBatchId();
//            for (Long batchId : batchIds) {
            initCommandService.initQueryCommand(iRequest, batchId);
//            }
        } catch (Exception e) {
            logger.error("\n query order error: {}", e);
            responseData.setMessage(e.getMessage());
            responseData.setSuccess(false);
            BankBatch bankBatch = new BankBatch();
            bankBatch.setBatchId(batchId);
            bankBatch.setStatus("RETURN_FAIL");
            recordMapper.updateBatchStatusWithOutDate(bankBatch);
        }
        return responseData;
    }

    @RequestMapping(value = "/incbc/interface/record/test")
    @ResponseBody
    public ResponseData test2(HttpServletRequest request) {
        IRequest iRequest = createRequestContext(request);


//        job.execute();
        return new ResponseData();
    }

    @RequestMapping(value = "/icbc/interface/record/withhold/submitorder")
    @ResponseBody
    public ResponseData submitOrderWithHold(HttpServletRequest request, @RequestParam Long batchId) {
        IRequest iRequest = createRequestContext(request);
        ResponseData responseData = new ResponseData();
        try {
            initWithHoldCommandService.initSendCommand(iRequest, batchId, IcbcUtils.PRODUCT_MODE);
        } catch (Exception e) {
            logger.error("submit with hold failed:{}", e);
            responseData.setMessage(e.getMessage());
            responseData.setSuccess(false);
        }
        return responseData;
    }


    @RequestMapping(value = "/icbc/interface/record/withhold/queryorder")
    @ResponseBody
    public ResponseData queryOrderWithHold(HttpServletRequest request, @RequestParam Long batchId) {
        IRequest iRequest = createRequestContext(request);
        ResponseData responseData = new ResponseData();
        try {
            initWithHoldCommandService.initQueryCommand(iRequest, batchId);
        } catch (Exception e) {
            logger.error("query with hold failed: {}", e);
            responseData.setSuccess(false);
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }


    @RequestMapping(value = "/icbc/interface/record/test2")
    @ResponseBody
    public ResponseData test(HttpServletRequest request) {
        SendCommand sendCommand = new SendCommand();

        IcbcPub icbcPub = new IcbcPub();
        icbcPub.setTransCode("PERDIS");
        icbcPub.setCis("020000459999AAA");
        icbcPub.setBankCode("102");
        icbcPub.setId("test20180101.y.0200");

//        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, 2018);
        calendar.set(Calendar.MONTH, 9);
        calendar.set(Calendar.DATE, 31);
        calendar.set(Calendar.MINUTE, calendar.get(Calendar.MINUTE) - 10);
        Date date = calendar.getTime();

        SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmssSSS");

        icbcPub.setTranDate(dateFormat.format(date));
        icbcPub.setTranTime(timeFormat.format(date));
        icbcPub.setfSeqno(dateTimeFormat.format(date));

        sendCommand.setIcbcPub(icbcPub);

        IcbcIn icbcIn = new IcbcIn();
        icbcIn.setOnlBatF("1");
        icbcIn.setSettleMode("0");
        icbcIn.setRecAccNo("0200004519000100297");
        icbcIn.setRecAccNameCN("");
        icbcIn.setTotalNum("2");
        icbcIn.setTotalAmt("12");
        icbcIn.setSignTime(dateTimeFormat.format(date));

        List<IcbcRd> list = new ArrayList<>();

        IcbcRd icbcRd = new IcbcRd();
        icbcRd.setiSeqno(String.valueOf(0));
        icbcRd.setPayAccNo("6222080200899996006");
        icbcRd.setPayAccNameCN("测试一");
        icbcRd.setPayBranch("工行");
        icbcRd.setPortno("A001");
        icbcRd.setContractNo("BDP300367942");
        icbcRd.setCurrType("001");
        icbcRd.setPayAmt("10");
        icbcRd.setUseCN("use");
        list.add(icbcRd);

        IcbcRd icbcRd2 = new IcbcRd();
        icbcRd2.setiSeqno(String.valueOf(1));
        icbcRd2.setPayAccNo("6222080200799005783");
        icbcRd2.setPayAccNameCN("测试二");
        icbcRd2.setPayBranch("工行");
        icbcRd2.setPortno("A002");
        icbcRd2.setContractNo("BDP300367942");
        icbcRd2.setCurrType("001");
        icbcRd2.setPayAmt("2");
        icbcRd2.setUseCN("use");
        list.add(icbcRd2);


        icbcIn.setRds(list);

        sendCommand.setIcbcIn(icbcIn);

        IRequest iRequest = createRequestContext(request);

        try {
            service.submitOrder(iRequest, sendCommand, "submit");
        } catch (Exception e) {
            logger.error("error: {}", e);
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
        return new ResponseData();
    }
}