package com.hand.hls.hlcm.hls.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import jodd.util.PropertiesUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.hand.hls.hlcm.hls.dto.HlsInterfaceLog;
import com.hand.hls.hlcm.hls.service.HlsInterfaceLogService;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.support.UUIDUtils;

import java.io.*;
import java.util.Map;
import java.util.Properties;

@Service
@Transactional(rollbackFor = Exception.class)
public class HlsInterfaceLogServiceImpl extends BaseServiceImpl<HlsInterfaceLog> implements HlsInterfaceLogService {
    /**
     * @Discription: 插入日志 完整参数
     * @param:
     * @return:
     */
    @Override
    public Long insertLog(IRequest iRequest, String interfaceName, String interfaceType, String message, String hostIp, String appIp, String requestMessage, String responseMessage, Map<String, String> inputParameters, Map<String, String> outputParameters) {
        HlsInterfaceLog hlsInterfaceLog = new HlsInterfaceLog();
        hlsInterfaceLog.setInterfaceName(interfaceName);
        hlsInterfaceLog.setInterfaceType(interfaceType);
        hlsInterfaceLog.setMessage(message);
        hlsInterfaceLog.setHostIp(hostIp);
        hlsInterfaceLog.setAppIp(appIp);
        hlsInterfaceLog.setResponseMessage(responseMessage);
        hlsInterfaceLog.setRequestMessage(requestMessage);
        hlsInterfaceLog.setInputParameter1(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_1));
        hlsInterfaceLog.setInputParameter2(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_2));
        hlsInterfaceLog.setInputParameter3(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_3));
        hlsInterfaceLog.setInputParameter4(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_4));
        hlsInterfaceLog.setInputParameter5(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_5));
        hlsInterfaceLog.setInputParameter6(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_6));
        hlsInterfaceLog.setInputParameter7(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_7));
        hlsInterfaceLog.setInputParameter8(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_8));
        hlsInterfaceLog.setInputParameter9(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_9));
        hlsInterfaceLog.setInputParameter10(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_10));
        hlsInterfaceLog.setInputParameter11(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_11));
        hlsInterfaceLog.setInputParameter12(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_12));
        hlsInterfaceLog.setInputParameter13(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_13));
        hlsInterfaceLog.setInputParameter14(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_14));
        hlsInterfaceLog.setInputParameter15(inputParameters.get(HlsInterfaceLog.FIELD_INPUT_PARAMETER_15));
        hlsInterfaceLog.setOutputParameter1(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_1));
        hlsInterfaceLog.setOutputParameter2(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_2));
        hlsInterfaceLog.setOutputParameter3(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_3));
        hlsInterfaceLog.setOutputParameter4(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_4));
        hlsInterfaceLog.setOutputParameter5(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_5));
        hlsInterfaceLog.setOutputParameter6(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_6));
        hlsInterfaceLog.setOutputParameter7(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_7));
        hlsInterfaceLog.setOutputParameter8(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_8));
        hlsInterfaceLog.setOutputParameter9(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_9));
        hlsInterfaceLog.setOutputParameter10(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_10));
        hlsInterfaceLog.setOutputParameter11(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_11));
        hlsInterfaceLog.setOutputParameter12(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_12));
        hlsInterfaceLog.setOutputParameter13(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_13));
        hlsInterfaceLog.setOutputParameter14(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_14));
        hlsInterfaceLog.setOutputParameter15(outputParameters.get(HlsInterfaceLog.FIELD_OUTPUT_PARAMETER_15));
        HlsInterfaceLog info = self().insertSelective(iRequest, hlsInterfaceLog);
        return info.getLogId();
    }

    /**
     * @Discription: 插入日志 部分参数
     * @param:
     * @return:
     */
    @Override
    public Long insertLog(IRequest iRequest, String interfaceName, String interfaceType, String message) {
        HlsInterfaceLog hlsInterfaceLog = new HlsInterfaceLog();
        hlsInterfaceLog.setInterfaceName(interfaceName);
        hlsInterfaceLog.setInterfaceType(interfaceType);
        hlsInterfaceLog.setMessage(message);
        HlsInterfaceLog info = self().insertSelective(iRequest, hlsInterfaceLog);
        return info.getLogId();
    }
}