package com.hand.hls.hlcm.acr.dto;

import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.system.dto.BaseDTO;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Author Robert8900
 * @Date: 2018/8/24 15:20
 * @Description:发票头表dto
 * @Purpose:
 **/
@ExtensionAttribute(disable = true)
@Table(name = "acr_invoice_hd")
public class AcrInvoiceHd extends BaseDTO {
    @Id
    @GeneratedValue
    private Long invoiceHdId;  //发票ID/PK
    private Long companyId;    //公司
    private Long spvCompanyId;
    private String documentNumber;  //单据编号（可能用来标识金税返回记录）
    private String documentType;    //单据类型
    private String documentCategory;   //单据类别 ‘AR_INVOICE’
    private String businessType;     //业务类型
    private String billingMethod;    //开票方式
    private String leaseOrganization;   //事业部
    private String leaseChannel;     //商业模式
    private String division;    //产品线
    private Long ownerUserId;    //单据所有者（用户ID）
    private String manualInvoiceFlag;   //手工发票（区别于根据合同创建的发票）
    private Long bpId;    //商业伙伴
    private String bpName;   //发票抬头/伙伴名称
    private String bpTaxRegistryNum;   //纳税人登记号
    private String bpAddressPhoneNum;   //地址及电话
    private String bpBankAccount;    //开户行及账号
    private String description;   //备注
    private Double totalAmount;   //价税合计
    private Double taxAmount;   //行税额合计
    private String currency;   //币种
    private String exchangeRateType;   //汇率类型
    private String exchangeRateQuotation;   //汇率标价方法
    private Double exchangeRate;  //汇率
    private Long distributionSetId;  //分配集ID
    private Long internalPeriodNum;   //期间序号
    private String periodName;   //期间名
    private Date accountingDate;   //记账日期
    private Date invoiceDate;   //发票日期（金税可回传）
    private String invoiceNumber;   //发票号（金税可回传）
    private String invoiceStatus;    //发票号（金税可回传）
    private Long projectId;   //来源项目
    private Long contractId;   //来源合同
    private String reversedFlag;   //反冲标志（N/未反冲 ，W/被反冲，R/反冲）
    private Date reverseDate;
    private Long sourceInvoiceHeaderId;   //被反冲发票ID
    private String createJeFlag;   //凭证生成标志（N/Y）
    private String gldInterfaceFlag;   //总账接口标志（N/Y）
    private Date confirmedDate;  //复核日期
    private Long confirmedBy;  //复核人
    private Date postedDate;   //过账日期
    private Long postedBy;   //过账人
    private String invoiceKind;  //发票种类（0-专用增票 / 2-普通增票 / RECEIPT-收据）
    private String vatInterfaceStatus;  //金税接口状态（PENDING-暂挂 / TRANSFERED-已传金税 / BACK-金税已回写）
    private String vatInvoiceCode;  //发票代码
    private String vatInvoiceStatus;  //发票状态（0-正常 / 1-作废 / 2-负数发票）
    private String vatRedNoticeNum;  //专用发票红票通知单号
    private String refVatInvoiceCode;  //普通红票的来源正数发票代码
    private String refInvoiceNumber;   //普通红票的来源正数发票号码
    private String expressStatus;   //发票寄送状态
    private Date expressDate;  //寄送日期
    private String expressCompany;  //快递公司
    private String expressNum;  //快递单号
    private Long expressBy;  //寄送人
    private String expressNote;  //寄送备注
    private String refV01;
    private String refV02;
    private String refV03;
    private String refV04;
    private String refV05;
    private String refV06;
    private String refV07;
    private String refV08;
    private String refV09;
    private String refV10;
    private Double refN01;
    private Double refN02;
    private Double refN03;
    private Double refN04;
    private Double refN05;
    private Double refN06;
    private Double refN07;
    private Double refN08;
    private Double refN09;
    private Double refN10;
    private Date refD01;
    private Date refD02;
    private Date refD03;
    private Date refD04;
    private Date refD05;
    private String receiptPrintStatus;
    private Date lastReceiptPrintTime;
    private String receiptNumber;  //收据编号
    private Double invoiceSubmitter;
    private Date invoiceSubmitDate;
    private String taxCode;
    private String taxMsg;

    public Long getInvoiceHdId() {
        return invoiceHdId;
    }

    public void setInvoiceHdId(Long invoiceHdId) {
        this.invoiceHdId = invoiceHdId;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public Long getSpvCompanyId() {
        return spvCompanyId;
    }

    public void setSpvCompanyId(Long spvCompanyId) {
        this.spvCompanyId = spvCompanyId;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocumentCategory() {
        return documentCategory;
    }

    public void setDocumentCategory(String documentCategory) {
        this.documentCategory = documentCategory;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getBillingMethod() {
        return billingMethod;
    }

    public void setBillingMethod(String billingMethod) {
        this.billingMethod = billingMethod;
    }

    public String getLeaseOrganization() {
        return leaseOrganization;
    }

    public void setLeaseOrganization(String leaseOrganization) {
        this.leaseOrganization = leaseOrganization;
    }

    public String getLeaseChannel() {
        return leaseChannel;
    }

    public void setLeaseChannel(String leaseChannel) {
        this.leaseChannel = leaseChannel;
    }

    public String getDivision() {
        return division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public Long getOwnerUserId() {
        return ownerUserId;
    }

    public void setOwnerUserId(Long ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    public String getManualInvoiceFlag() {
        return manualInvoiceFlag;
    }

    public void setManualInvoiceFlag(String manualInvoiceFlag) {
        this.manualInvoiceFlag = manualInvoiceFlag;
    }

    public Long getBpId() {
        return bpId;
    }

    public void setBpId(Long bpId) {
        this.bpId = bpId;
    }

    public String getBpName() {
        return bpName;
    }

    public void setBpName(String bpName) {
        this.bpName = bpName;
    }

    public String getBpTaxRegistryNum() {
        return bpTaxRegistryNum;
    }

    public void setBpTaxRegistryNum(String bpTaxRegistryNum) {
        this.bpTaxRegistryNum = bpTaxRegistryNum;
    }

    public String getBpAddressPhoneNum() {
        return bpAddressPhoneNum;
    }

    public void setBpAddressPhoneNum(String bpAddressPhoneNum) {
        this.bpAddressPhoneNum = bpAddressPhoneNum;
    }

    public String getBpBankAccount() {
        return bpBankAccount;
    }

    public void setBpBankAccount(String bpBankAccount) {
        this.bpBankAccount = bpBankAccount;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Double getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(Double taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getExchangeRateType() {
        return exchangeRateType;
    }

    public void setExchangeRateType(String exchangeRateType) {
        this.exchangeRateType = exchangeRateType;
    }

    public String getExchangeRateQuotation() {
        return exchangeRateQuotation;
    }

    public void setExchangeRateQuotation(String exchangeRateQuotation) {
        this.exchangeRateQuotation = exchangeRateQuotation;
    }

    public Double getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(Double exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public Long getDistributionSetId() {
        return distributionSetId;
    }

    public void setDistributionSetId(Long distributionSetId) {
        this.distributionSetId = distributionSetId;
    }

    public Long getInternalPeriodNum() {
        return internalPeriodNum;
    }

    public void setInternalPeriodNum(Long internalPeriodNum) {
        this.internalPeriodNum = internalPeriodNum;
    }

    public String getPeriodName() {
        return periodName;
    }

    public void setPeriodName(String periodName) {
        this.periodName = periodName;
    }

    public Date getAccountingDate() {
        return accountingDate;
    }

    public void setAccountingDate(Date accountingDate) {
        this.accountingDate = accountingDate;
    }

    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(String invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getReversedFlag() {
        return reversedFlag;
    }

    public void setReversedFlag(String reversedFlag) {
        this.reversedFlag = reversedFlag;
    }

    public Date getReverseDate() {
        return reverseDate;
    }

    public void setReverseDate(Date reverseDate) {
        this.reverseDate = reverseDate;
    }

    public Long getSourceInvoiceHeaderId() {
        return sourceInvoiceHeaderId;
    }

    public void setSourceInvoiceHeaderId(Long sourceInvoiceHeaderId) {
        this.sourceInvoiceHeaderId = sourceInvoiceHeaderId;
    }

    public String getCreateJeFlag() {
        return createJeFlag;
    }

    public void setCreateJeFlag(String createJeFlag) {
        this.createJeFlag = createJeFlag;
    }

    public String getGldInterfaceFlag() {
        return gldInterfaceFlag;
    }

    public void setGldInterfaceFlag(String gldInterfaceFlag) {
        this.gldInterfaceFlag = gldInterfaceFlag;
    }

    public Date getConfirmedDate() {
        return confirmedDate;
    }

    public void setConfirmedDate(Date confirmedDate) {
        this.confirmedDate = confirmedDate;
    }

    public Long getConfirmedBy() {
        return confirmedBy;
    }

    public void setConfirmedBy(Long confirmedBy) {
        this.confirmedBy = confirmedBy;
    }

    public Date getPostedDate() {
        return postedDate;
    }

    public void setPostedDate(Date postedDate) {
        this.postedDate = postedDate;
    }

    public Long getPostedBy() {
        return postedBy;
    }

    public void setPostedBy(Long postedBy) {
        this.postedBy = postedBy;
    }

    public String getInvoiceKind() {
        return invoiceKind;
    }

    public void setInvoiceKind(String invoiceKind) {
        this.invoiceKind = invoiceKind;
    }

    public String getVatInterfaceStatus() {
        return vatInterfaceStatus;
    }

    public void setVatInterfaceStatus(String vatInterfaceStatus) {
        this.vatInterfaceStatus = vatInterfaceStatus;
    }

    public String getVatInvoiceCode() {
        return vatInvoiceCode;
    }

    public void setVatInvoiceCode(String vatInvoiceCode) {
        this.vatInvoiceCode = vatInvoiceCode;
    }

    public String getVatInvoiceStatus() {
        return vatInvoiceStatus;
    }

    public void setVatInvoiceStatus(String vatInvoiceStatus) {
        this.vatInvoiceStatus = vatInvoiceStatus;
    }

    public String getVatRedNoticeNum() {
        return vatRedNoticeNum;
    }

    public void setVatRedNoticeNum(String vatRedNoticeNum) {
        this.vatRedNoticeNum = vatRedNoticeNum;
    }

    public String getRefVatInvoiceCode() {
        return refVatInvoiceCode;
    }

    public void setRefVatInvoiceCode(String refVatInvoiceCode) {
        this.refVatInvoiceCode = refVatInvoiceCode;
    }

    public String getRefInvoiceNumber() {
        return refInvoiceNumber;
    }

    public void setRefInvoiceNumber(String refInvoiceNumber) {
        this.refInvoiceNumber = refInvoiceNumber;
    }

    public String getExpressStatus() {
        return expressStatus;
    }

    public void setExpressStatus(String expressStatus) {
        this.expressStatus = expressStatus;
    }

    public Date getExpressDate() {
        return expressDate;
    }

    public void setExpressDate(Date expressDate) {
        this.expressDate = expressDate;
    }

    public String getExpressCompany() {
        return expressCompany;
    }

    public void setExpressCompany(String expressCompany) {
        this.expressCompany = expressCompany;
    }

    public String getExpressNum() {
        return expressNum;
    }

    public void setExpressNum(String expressNum) {
        this.expressNum = expressNum;
    }

    public Long getExpressBy() {
        return expressBy;
    }

    public void setExpressBy(Long expressBy) {
        this.expressBy = expressBy;
    }

    public String getExpressNote() {
        return expressNote;
    }

    public void setExpressNote(String expressNote) {
        this.expressNote = expressNote;
    }

    public String getRefV01() {
        return refV01;
    }

    public void setRefV01(String refV01) {
        this.refV01 = refV01;
    }

    public String getRefV02() {
        return refV02;
    }

    public void setRefV02(String refV02) {
        this.refV02 = refV02;
    }

    public String getRefV03() {
        return refV03;
    }

    public void setRefV03(String refV03) {
        this.refV03 = refV03;
    }

    public String getRefV04() {
        return refV04;
    }

    public void setRefV04(String refV04) {
        this.refV04 = refV04;
    }

    public String getRefV05() {
        return refV05;
    }

    public void setRefV05(String refV05) {
        this.refV05 = refV05;
    }

    public String getRefV06() {
        return refV06;
    }

    public void setRefV06(String refV06) {
        this.refV06 = refV06;
    }

    public String getRefV07() {
        return refV07;
    }

    public void setRefV07(String refV07) {
        this.refV07 = refV07;
    }

    public String getRefV08() {
        return refV08;
    }

    public void setRefV08(String refV08) {
        this.refV08 = refV08;
    }

    public String getRefV09() {
        return refV09;
    }

    public void setRefV09(String refV09) {
        this.refV09 = refV09;
    }

    public String getRefV10() {
        return refV10;
    }

    public void setRefV10(String refV10) {
        this.refV10 = refV10;
    }

    public Double getRefN01() {
        return refN01;
    }

    public void setRefN01(Double refN01) {
        this.refN01 = refN01;
    }

    public Double getRefN02() {
        return refN02;
    }

    public void setRefN02(Double refN02) {
        this.refN02 = refN02;
    }

    public Double getRefN03() {
        return refN03;
    }

    public void setRefN03(Double refN03) {
        this.refN03 = refN03;
    }

    public Double getRefN04() {
        return refN04;
    }

    public void setRefN04(Double refN04) {
        this.refN04 = refN04;
    }

    public Double getRefN05() {
        return refN05;
    }

    public void setRefN05(Double refN05) {
        this.refN05 = refN05;
    }

    public Double getRefN06() {
        return refN06;
    }

    public void setRefN06(Double refN06) {
        this.refN06 = refN06;
    }

    public Double getRefN07() {
        return refN07;
    }

    public void setRefN07(Double refN07) {
        this.refN07 = refN07;
    }

    public Double getRefN08() {
        return refN08;
    }

    public void setRefN08(Double refN08) {
        this.refN08 = refN08;
    }

    public Double getRefN09() {
        return refN09;
    }

    public void setRefN09(Double refN09) {
        this.refN09 = refN09;
    }

    public Double getRefN10() {
        return refN10;
    }

    public void setRefN10(Double refN10) {
        this.refN10 = refN10;
    }

    public Date getRefD01() {
        return refD01;
    }

    public void setRefD01(Date refD01) {
        this.refD01 = refD01;
    }

    public Date getRefD02() {
        return refD02;
    }

    public void setRefD02(Date refD02) {
        this.refD02 = refD02;
    }

    public Date getRefD03() {
        return refD03;
    }

    public void setRefD03(Date refD03) {
        this.refD03 = refD03;
    }

    public Date getRefD04() {
        return refD04;
    }

    public void setRefD04(Date refD04) {
        this.refD04 = refD04;
    }

    public Date getRefD05() {
        return refD05;
    }

    public void setRefD05(Date refD05) {
        this.refD05 = refD05;
    }

    public String getReceiptPrintStatus() {
        return receiptPrintStatus;
    }

    public void setReceiptPrintStatus(String receiptPrintStatus) {
        this.receiptPrintStatus = receiptPrintStatus;
    }

    public Date getLastReceiptPrintTime() {
        return lastReceiptPrintTime;
    }

    public void setLastReceiptPrintTime(Date lastReceiptPrintTime) {
        this.lastReceiptPrintTime = lastReceiptPrintTime;
    }

    public String getReceiptNumber() {
        return receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public Double getInvoiceSubmitter() {
        return invoiceSubmitter;
    }

    public void setInvoiceSubmitter(Double invoiceSubmitter) {
        this.invoiceSubmitter = invoiceSubmitter;
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public String getTaxMsg() {
        return taxMsg;
    }

    public void setTaxMsg(String taxMsg) {
        this.taxMsg = taxMsg;
    }

    public Date getInvoiceSubmitDate() {
        return invoiceSubmitDate;
    }

    public void setInvoiceSubmitDate(Date invoiceSubmitDate) {
        this.invoiceSubmitDate = invoiceSubmitDate;
    }


}
