package com.hand.hls.hlcm.util.acr;

import com.hand.hls.hlcm.acr.dto.AcrEleInvoiceHd;
import com.hand.hls.hlcm.acr.dto.AcrInvoiceHd;
import com.hand.hls.hlcm.acr.mapper.AcrEleInvoiceHdMapper;

import java.util.List;

/**
 * @Author Robert8900
 * @Date: 2018/8/28 10:39
 * @Description: 发票下载接口 封装报文工具类
 * @Purpose:
 **/
public class AcrInfoDownloadXmlUtil {
    //封装报文
    public static String getXml(AcrInvoiceHd acrInvoiceHd, AcrEleInvoiceHdMapper acrEleInvoiceHdMapper){
        StringBuilder stringBuilder = new StringBuilder();
        //报文 header 命名空间
        stringBuilder.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://service.ejinshui.com/\">\n");
        stringBuilder.append("<soapenv:Header/>\n");
        stringBuilder.append("<soapenv:Body>\n");
        stringBuilder.append("<ser:downloadEInvoiceInfo>");

        //报文格式
        stringBuilder.append("<arg0><![CDATA[<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        stringBuilder.append("<InvoInfo>");

        //头表信息(通过发票头表ID 找电子发票头表 只有一条)
        AcrEleInvoiceHd hd = new AcrEleInvoiceHd();
        hd.setInvoiceHdId(acrInvoiceHd.getInvoiceHdId());
        List<AcrEleInvoiceHd> acrEleInvoiceHds = acrEleInvoiceHdMapper.getAcrEleHdInfo(hd);
        AcrEleInvoiceHd acrEleInvoiceHd = acrEleInvoiceHds.get(0);
        //报文详细内容
        //流水号
        stringBuilder.append("<swno>");
        stringBuilder.append(acrEleInvoiceHd.getSwno());
        stringBuilder.append("</swno>");
        //销方税号
        stringBuilder.append("<saleTax>");
        stringBuilder.append(acrEleInvoiceHd.getSaleTax());
        stringBuilder.append("</saleTax>");

        //格式结束
        stringBuilder.append("</InvoInfo>]]></arg0>");

        //报文 footer 命名空间结束
        stringBuilder.append("</ser:downloadEInvoiceInfo>\n");
        stringBuilder.append("</soapenv:Body>\n");
        stringBuilder.append("</soapenv:Envelope>");

        return stringBuilder.toString();
    }
}
