package com.hand.hls.hlcm.util;

import net.sf.json.JSONObject;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.mail.*;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.util.Properties;

public class MailSend {
    private static final Logger logger = LoggerFactory.getLogger(MailSend.class);
    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }
    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }

    public   String sendMain(String jsonData) {
        JSONObject jsonObject = JSONObject.fromObject(jsonData);
        JSONObject js=new JSONObject();
        // 发件人电子邮箱
        String from = jsonObject.optString("serverAddress");
//获取系统属性，主要用于设置邮件相关的参数。
        Properties properties = System.getProperties();
        //smtp协议地址
        properties.setProperty("mail.smtp.host", jsonObject.optString("serverHost"));
        //端口号
        properties.setProperty("mail.smtp.port", jsonObject.optString("serverPort"));
        properties.setProperty("mail.smtp.starttls.enable", "true");
        properties.setProperty("mail.smtp.socketFactory.fallback", "true");
        properties.setProperty("mail.smtp.auth", "true");
        //发送者账号密码
        Session session = Session.getDefaultInstance(properties, new Authenticator() {
            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(jsonObject.optString("serverName"), jsonObject.optString("serverPassWord"));
            }

        });

//创建MimeMessage消息对象，消息头配置了收发邮箱的地址，消息体包含了邮件标题和邮件内容。接收者类型：TO代表直接发送，CC代表抄送，BCC代表秘密抄送。
        try {
            MimeMessage message = new MimeMessage(session);
            message.addHeader("X-Mailer", "Microsoft Outlook Express 6.00.2900.2869");
            message.setFrom(new InternetAddress(from));
            message.addRecipient(Message.RecipientType.TO, new InternetAddress(jsonObject.optString("toAddress")));
            if (isNotEmpty(jsonObject.optString("toCcAddress"))){
                String[] params = jsonObject.optString("toCcAddress").split(";");
            if (params.length > 0) {
                InternetAddress[] sendCc = new InternetAddress[params.length];
                for (int i = 0; i < params.length; i++) {
                    sendCc[i] = new InternetAddress(params[i]);
                }
                message.addRecipients(MimeMessage.RecipientType.CC, sendCc);
            }}
            message.setSubject(jsonObject.optString("toSubject"));
            message.setText(jsonObject.optString("toBody"));
            Transport.send(message);
            logger.info("send Success!");
            js.put("status",'S');
        } catch (MessagingException e) {
            logger.error("send Error!", e);
            js.put("status",'E');
            js.put("errorMsg",e.getMessage());
        }
return js.toString();
    }


    // 做测试用
    @Test
    public void test() {
        MailSend mailSend=new MailSend();
        //MailSend.sendMain("790553035@qq.com");
    }

}
