package leaf.presentation.component.std;

import leaf.presentation.BuildSession;
import leaf.presentation.ViewContext;
import leaf.presentation.component.std.Component;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

import java.io.IOException;
import java.util.List;
import java.util.Map;

public class HapGrid extends Component {
    public static final String CONFIG_CONTEXT = "/request/@context_path";

    public HapGrid(IObjectRegistry registry) {
        super(registry);
    }
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        addStyleSheet(session, context, "hapGrid/hapGrid.css");
        addJavaScript(session, context, "hapGrid/hapGrid.js");
    }



    public JSONArray getColumnList(BuildSession session, CompositeMap view){
        JSONArray jsons = new JSONArray();
        if(view.getChilds() != null && view.getChilds().size() > 0){
            CompositeMap columns = new CompositeMap();
            if(view.getChilds().size() == 1){
                 columns = (CompositeMap) view.getChilds().get(0);
            }else {
                 columns = (CompositeMap) view.getChilds().get(1);
            }
            if(columns != null){
                List<CompositeMap> list = columns.getChilds();
                for(int i = 0; i < list.size(); i++){
                    JSONObject json = new JSONObject(list.get(i));
                    jsons.put(json);
                }
            }

        }
        return jsons;
    }

    public JSONArray getToolBars(BuildSession session, CompositeMap view) {
        JSONArray jsons = new JSONArray();
        if (view.getChilds() != null && view.getChilds().size() > 0) {
            CompositeMap columns = new CompositeMap();
            if (view.getChilds().size() == 2) {
                columns = (CompositeMap) view.getChilds().get(0);
                if (columns.getChilds() != null) {
                    List<CompositeMap> list = columns.getChilds();
                    for (int i = 0; i < list.size(); i++) {
                        JSONObject json = new JSONObject(list.get(i));
                        jsons.put(json);
                    }
                }
            }
        }
        return jsons;
    }

    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException{
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();

        Map map = context.getMap();
        addConfig("columns", getColumnList(session,view));
        addConfig("toolbars",getToolBars(session,view));
        map.put("config",getConfigString());
        if(view.get("bindtarget") != null) {
            map.put("bindtarget", view.get("bindtarget"));
        }
        if(view.get("id") != null) {
            map.put("id", view.get("id"));
        }
        if(view.get("title") != null) {
            map.put("title", view.get("title"));
        }
        if(view.get("titleimg") != null){
            map.put("titleimg",view.get("titleimg"));
        }
        if (session.getContextPath() != null)
            map.put(CONFIG_CONTEXT, session.getContextPath());

//        map.put(CONFIG, getConfigString());
    }
}
