/**
 * Copyright (C) Hand Business Consulting Services
 * AllRights Reserved
 *
 * @Auther: Xianfei Zhu
 * @Date: 2018-09-10 13:22
 * @Description: 金税纸质发票xml反馈报文解析
 */

package com.hand.hls.hlcm.jinsui.util;

import java.util.HashMap;
import java.util.Iterator;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public class ReadStringXmlUtil {

    //XML报文解析节点
    private static String InfoAmountNode = "InfoAmount";   //InfoAmount 发票金额
    private static String InfoTaxAmountNode = "InfoTaxAmount";   //InfoTaxAmount 税额
    private static String InfoNumberNode = "InfoNumber"; //InfoNumber 发票号码
    private static String InfoNumberStrNode = "InfoNumberStr"; //八位发票号码
    private static String InfoInvKindNode = "InfoInvKind";  //InfoInvKind  发票种类
    private static String RetCodeNode = "RetCode";        // RetCode节点  返回code
    private static String RetMsgNode = "RetMsg";        //RetMsg节点   返回信息
    private static String InvStockNode = "InvStock";        //InvStock节点  剩余开票数量
    private static String InfoDateNode = "InfoDate";        //InfoDate 开票时间
    private static String InfoTypeCodeNode = "InfoTypeCode";  //InfoTypeCode 发票类别代码
    private static String TaxCodeNode = "TaxCode";        //TaxCode 税号
    private static String InvCancleFlagCode = "invCancleFlag";      //作废标志 (0：未作废，1：已作废)
    private static String GoodsListFlagCode = "GoodsListFlag";      //清单标志（0：不带清单，1：带清单）


    private static String BodyNode = "Body";        //Body节点
    private static String MakeInvResponseNode = "MakeInvResponse"; //MakeInvResponse 节点
    private static String TRecResultInfoNode = "TRecResultInfo";  //TRecResultInfo 节点


    /**
     * @param xml
     * @return Map
     * @description 金税纸质发票xml反馈报文解析
     */

    public static HashMap<String, Object> readStringXmlOut(String xml) {

        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            // 将字符串转为XML
            Document doc = DocumentHelper.parseText(xml);
            // 获取根节点
            Element rootElt = doc.getRootElement();
            // 拿到根节点的名称
            //System.out.println("根节点：" + rootElt.getName());
            //获取根节点下的子节点body
            Iterator bodyIterss = rootElt.elementIterator(BodyNode);

            //遍历Body节点
            while (bodyIterss.hasNext()) {
                Element bodyEless = (Element) bodyIterss.next();
                Iterator iterss = bodyEless.elementIterator(MakeInvResponseNode);
                //Iterator iterss = bodyEless.elementIterator(TRecResultInfoNode);
                //遍历body节点MakeInvResponse节点
                while (iterss.hasNext()) {
                    Element recordEless = (Element) iterss.next();
                    // 获取子节点MakeInvResponse下的子节点TRecResultInfo
                    Iterator itersElIterator = recordEless.elementIterator(TRecResultInfoNode);
                    //遍历TRecResultInfo节点下的子节点
                    while (itersElIterator.hasNext()) {
                        Element itemEle = (Element) itersElIterator.next();
                        // 拿到TRecResultInfo下的子节点值
                        String InfoAmount = itemEle.elementTextTrim(InfoAmountNode);   //InfoAmount 发票金额
                        String InfoTaxAmount = itemEle.elementTextTrim(InfoTaxAmountNode);   //InfoTaxAmount 税额
                        String InfoNumber = itemEle.elementTextTrim(InfoNumberNode);  //InfoNumber 发票号码
                        String InfoInvKind = itemEle.elementTextTrim(InfoInvKindNode);  //InfoInvKind  发票种类
                        String RetCode = itemEle.elementTextTrim(RetCodeNode);         // RetCode  返回代码
                        String RetMsg = itemEle.elementTextTrim(RetMsgNode);         //RetMsg  返回信息
                        String InvStock = itemEle.elementTextTrim(InvStockNode);     //InvStock  剩余开票数量
                        String InfoDate = itemEle.elementTextTrim(InfoDateNode);     //InfoDate   开票时间
                        String InfoTypeCode = itemEle.elementTextTrim(InfoTypeCodeNode);     //InfoTypeCode   发票类别代码
                        String TaxCode = itemEle.elementTextTrim(TaxCodeNode);     //InfoDate   税号
                        //String InvCancleFlag = itemEle.elementTextTrim(InvCancleFlagCode);  //作废标志(0：未作废，1：已作废)
                        String GoodsListFlag = itemEle.elementTextTrim(GoodsListFlagCode);  //清单标志（0：不带清单，1：带清单）
                        //String InfoNumberStr = itemEle.elementTextTrim(InfoNumberStrNode);  //8位数发票号码

                        //将解析值放入map
                        map.put("InfoAmount", InfoAmount);
                        map.put("InfoNumber", InfoNumber);
                        map.put("InfoInvKind", InfoInvKind);
                        map.put("RetCode", RetCode);
                        map.put("RetMsg", RetMsg);
                        map.put("InvStock", InvStock);
                        map.put("InfoDate", InfoDate);
                        map.put("InfoTypeCode", InfoTypeCode);
                        map.put("TaxCode", TaxCode);
                        map.put("InfoTaxAmount", InfoTaxAmount);
                        //map.put("InvCancleFlag", InvCancleFlag);
                        map.put("GoodsListFlag", GoodsListFlag);


                    }
                }
            }
        } catch (DocumentException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }



    /**
     * @param xml
     * @return Map
     * @description 红字申请单反馈报文解析
     */

    public static HashMap<String, Object> readRedNumXmlOut(String xml) {

        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            // 将字符串转为XML
            Document doc = DocumentHelper.parseText(xml);
            // 获取根节点
            Element rootElt = doc.getRootElement();
            // 拿到根节点的名称
            //System.out.println("根节点：" + rootElt.getName());
            //获取根节点下的子节点body
            Iterator bodyIterss = rootElt.elementIterator(BodyNode);

            //遍历Body节点
            while (bodyIterss.hasNext()) {
                Element bodyEless = (Element) bodyIterss.next();
                Iterator iterss = bodyEless.elementIterator(MakeInvResponseNode);
                //Iterator iterss = bodyEless.elementIterator(TRecResultInfoNode);
                //遍历body节点MakeInvResponse节点
                while (iterss.hasNext()) {
                    Element recordEless = (Element) iterss.next();
                    // 获取子节点MakeInvResponse下的子节点TRecResultInfo
                    Iterator itersElIterator = recordEless.elementIterator(TRecResultInfoNode);
                    //遍历TRecResultInfo节点下的子节点
                    while (itersElIterator.hasNext()) {
                        Element itemEle = (Element) itersElIterator.next();
                        // 拿到TRecResultInfo下的子节点值
                        String InfoAmount = itemEle.elementTextTrim(InfoAmountNode);   //InfoAmount 发票金额
                        String InfoTaxAmount = itemEle.elementTextTrim(InfoTaxAmountNode);   //InfoTaxAmount 税额
                        String InfoNumber = itemEle.elementTextTrim(InfoNumberNode);  //InfoNumber 发票号码
                        String InfoInvKind = itemEle.elementTextTrim(InfoInvKindNode);  //InfoInvKind  发票种类
                        String RetCode = itemEle.elementTextTrim(RetCodeNode);         // RetCode  返回代码
                        String RetMsg = itemEle.elementTextTrim(RetMsgNode);         //RetMsg  返回信息
                        String InvStock = itemEle.elementTextTrim(InvStockNode);     //InvStock  剩余开票数量
                        String InfoDate = itemEle.elementTextTrim(InfoDateNode);     //InfoDate   开票时间
                        String InfoTypeCode = itemEle.elementTextTrim(InfoTypeCodeNode);     //InfoTypeCode   发票类别代码
                        String TaxCode = itemEle.elementTextTrim(TaxCodeNode);     //InfoDate   税号
                        //String InvCancleFlag = itemEle.elementTextTrim(InvCancleFlagCode);  //作废标志(0：未作废，1：已作废)
                        String GoodsListFlag = itemEle.elementTextTrim(GoodsListFlagCode);  //清单标志（0：不带清单，1：带清单）
                        //String InfoNumberStr = itemEle.elementTextTrim(InfoNumberStrNode);  //8位数发票号码

                        //将解析值放入map
                        map.put("InfoAmount", InfoAmount);
                        map.put("InfoNumber", InfoNumber);
                        map.put("InfoInvKind", InfoInvKind);
                        map.put("RetCode", RetCode);
                        map.put("RetMsg", RetMsg);
                        map.put("InvStock", InvStock);
                        map.put("InfoDate", InfoDate);
                        map.put("InfoTypeCode", InfoTypeCode);
                        map.put("TaxCode", TaxCode);
                        map.put("InfoTaxAmount", InfoTaxAmount);
                        //map.put("InvCancleFlag", InvCancleFlag);
                        map.put("GoodsListFlag", GoodsListFlag);


                    }
                }
            }
        } catch (DocumentException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }


}