package leaf.plugin.word2pdf;

import java.io.*;
import com.aspose.cells.Workbook;
import com.aspose.slides.Presentation;
import com.aspose.slides.SaveFormat;
import com.aspose.words.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsposeUtil {
	private static final Logger logger = LoggerFactory.getLogger(AsposeUtil.class);
	//校验license
	private static boolean judgeLicense() {
		boolean result = false;
		try {
			InputStream is = AsposeUtil.class.getClassLoader().getResourceAsStream("license.xml");
			License aposeLic = new License();
			aposeLic.setLicense(is);
			result = true;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}

	// 转换
	public static void trans(String filePath, String pdfPath, String type) {
		if (!judgeLicense()) {
			logger.error("error","license错误");
		}
		try {
			logger.info("as开始：" + filePath);
			long old = System.currentTimeMillis();
			File file = new File(pdfPath);

			if (file.exists()) {
				file.delete();
			}
			toPdf(file, filePath, type);
			long now = System.currentTimeMillis();
			logger.info("完成：" + pdfPath);
			logger.info("共耗时：" + ((now - old) / 1000.0) + "秒");
		} catch (Exception e) {
			logger.error("pdf转换失败", e);
		} 
	}

	private static void toPdf(File file, String filePath, String type) {
		if ("word".equals(type) || "txt".equals(type)) {
			wordofpdf(file, filePath);
		} else if ("excel".equals(type)) {
			exceOfPdf(file, filePath);
		} else if ("ppt".equals(type)) {
			pptofpdf(file, filePath);
		}else{
			logger.error("error", "暂不支持该类型："+type);
		}
	}

	private static void wordofpdf(File file, String filePath) {
		FileOutputStream os = null;
		Document doc;
		try {
			os = new FileOutputStream(file);
			doc = new Document(filePath);
			doc.save(os, com.aspose.words.SaveFormat.PDF);
		} catch (Exception e) {
			logger.error("pdf转换失败", e);
		} finally {
			try {
				os.close();
			} catch (IOException e) {
				logger.error("pdf转换失败", e);
			}
		}
	}

	private static void exceOfPdf(File file, String filePath) {
		FileOutputStream os = null;
		try {
			os = new FileOutputStream(file);
			Workbook wb = new Workbook(filePath);
			wb.save(os, com.aspose.cells.SaveFormat.PDF);
		} catch (Exception e) {
			logger.error("pdf转换失败", e);
		} finally {
			try {
				os.close();
			} catch (IOException e) {
				logger.error("pdf转换失败", e);
			}
		}
	}

	private static void pptofpdf(File file, String filePath) {
		FileOutputStream os = null;
		try {
			os = new FileOutputStream(file);
			Presentation pres = new Presentation(filePath);// 输入pdf路径
			pres.save(os, SaveFormat.Pdf);
		} catch (Exception e) {
			logger.error("pdf转换失败", e);
		} finally {
			try {
				os.close();
			} catch (IOException e) {
				logger.error("pdf转换失败", e);
			}
		}

	}
	public static void main(String[] args) throws Exception {

//		String jacobDllPath = "D:\\ideaProjects\\leaf-hlcm\\src\\main\\webapp\\WEB-INF\\server-script\\jacob\\jacob-1.18-x64.dll";
//		System.setProperty("jacob.dll.path", jacobDllPath);
//		System.setProperty("com.jacob.debug", "true");
//		trans("D:\\u01\\hls_file\\excel\\8F5D12B0B1504518928FDD193C67A0A5con28168",
	//			"D:\\hand-Prpjects\\融资租赁合同文本-5pdf.pdf","word");
//        cutPdf("D:\\\\hand-Prpjects\\\\付款请求书打印.pdf");
//		excel2pdf("D:\\work\\leafProjects\\YondaTl\\src\\test.xlsx",
//				"D:\\work\\leafProjects\\YondaTl\\src\\付款通知书NEW.pdf");
//		excel2pdfOrientation("D:\\work\\leafProjects\\YondaTl\\src\\test.xlsx",
//				"D:\\work\\leafProjects\\YondaTl\\src\\付款通知书NEW.pdf");
	}

}
