package com.hand.hls.hlcm.util;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * Created with IntelliJ IDEA.
 * Description:
 * User: huangtianyang
 * Date: 2018-08-23
 * Time: 上午9:24
 */
public class HlsFileUtil {

    private static Logger logger = LoggerFactory.getLogger(HlsFileUtil.class);

    /**
     * 批量打包
     *
     * @param files    需要打包的文件
     * @param fileName 压缩文件名
     */
    public static void zipFile(List<File> files, String fileName) throws IOException {
        File zipFile = new File(fileName);
        FileOutputStream outputStream = new FileOutputStream(zipFile);
        ZipOutputStream out = new ZipOutputStream(outputStream);
//        byte[] buffer = new byte[1024];
        for (File file : files) {
            FileInputStream in = null;
            if (file.exists() && !file.isDirectory()) {
                in = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(file.getName()));
                IOUtils.copy(in, out);
//                IOUtils.read(in, buffer);
//                IOUtils.write(buffer, out);
            }
            IOUtils.closeQuietly(in);
        }
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(outputStream);
    }

    /*
     * copy from weck
     * */
    public static void downloadFile(String filePath, String fileName, HttpServletResponse response) {
        File file = new File(filePath);
        if (!file.exists()) {
            logger.error("target file does not exists.");
            response.setStatus(HttpStatus.SC_NO_CONTENT);
        } else {
            response.setContentType("application/octet-stream");
//          response.setContentType("application/force-download");// 设置强制下载不打开
//          response.setContentType("multipart/form-data");
            response.addHeader("Content-Disposition",
                    "attachment;fileName=" + fileName);// 设置文件名
            response.setContentLength((int) (FileUtils.sizeOf(file)));
            FileInputStream is = null;
            OutputStream os = null;
            doFileStream(response, file, is, os);
        }
    }

    public static void downloadFile(String filePath, String fileName, HttpServletResponse response, String fileType) {
        File file = new File(filePath);
        if (!file.exists()) {
            logger.error("target file does not exists.");
            response.setStatus(HttpStatus.SC_NO_CONTENT);
        } else {
            response.setContentType(chooseMimeType(fileType));
//          response.setContentType("application/force-download");// 设置强制下载不打开
//          response.setContentType("multipart/form-data");
            response.addHeader("Content-Disposition",
                    chooseHeader(fileName, fileType));// 设置文件名
            response.setContentLength((int) (FileUtils.sizeOf(file)));
            FileInputStream is = null;
            OutputStream os = null;
            doFileStream(response, file, is, os);
        }
    }

    private static void doFileStream(HttpServletResponse response, File file, FileInputStream is, OutputStream os) {
        try {
            is = new FileInputStream(file);
            os = response.getOutputStream();
            IOUtils.copy(is, os);
        } catch (Exception e) {
            logger.error("io transformation failed when download file.", e);
        } finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
        }
    }

    private static String chooseMimeType(String suffix) {
        String mimeType;
        switch (suffix) {
            case "pdf":
                mimeType = "application/pdf";
                break;
            default:
                mimeType = "application/octet-stream";
        }

        return mimeType;
    }

    private static String chooseHeader(String fileName, String type) {
        String header;
        switch (type) {
            case "pdf":
                header = "inline;fileName=" + fileName;
                break;
            default:
                header = "attachment;fileName=" + fileName;
        }
        return header;
    }

}
