/*
 * Created on 2009-9-3 上午10:56:14
 * Author: Zhou Fan
 */
package leaf.service.http;

import com.hand.hap.core.impl.RequestHelper;
import com.hand.hls.utils.SpringContextHolder;
import leaf.cache.ListCompositeMapRedisCache;
import leaf.events.E_DetectProcedure;
import leaf.events.E_ServiceFinish;
import leaf.service.*;
import leaf.transaction.ITransactionService;
import leaf.transaction.UserTransactionImpl;
import org.json.JSONObject;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.event.Configuration;
import uncertain.event.IEventDispatcher;
import uncertain.event.IParticipantManager;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.IProcedureRegistry;
import uncertain.proc.Procedure;
import uncertain.proc.trace.StackTraceManager;
import uncertain.proc.trace.TraceElement;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.UserTransaction;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractFacadeServlet extends HttpServlet {

    //public static final String POST_SERVICE = "post-service";
    public static final String PRE_SERVICE = "pre-service";
    public static final String QUERY_FILTER_NAME = "trx_id";
    protected UncertainEngine mUncertainEngine;
    protected IProcedureManager mProcManager;
    protected ServletConfig mConfig;
    protected ServletContext mContext;
    protected IProcedureRegistry mProcRegistry;
    private static final String DEFAULT_CSRF_TOKEN_ATTR_NAME = HttpSessionCsrfTokenRepository.class
            .getName().concat(".CSRF_TOKEN");
    //Procedure mPreServiceProc;
    //Procedure mPostServiceProc;

    Configuration mGlobalServiceConfig;

    protected abstract IService createServiceInstance(
            HttpServletRequest request, HttpServletResponse response)
            throws Exception;

    protected abstract void populateService(HttpServletRequest request,
                                            HttpServletResponse response, IService service) throws Exception;

    protected abstract void handleException(HttpServletRequest request,
                                            HttpServletResponse response, Throwable ex) throws IOException, ServletException;

    protected abstract void cleanUp(IService service);

    /**
     * By default, set no-cache directive to client.
     * Sub class can override this method to provide customized cache control.
     */
    protected void writeCacheDirection(HttpServletResponse response, IService service) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
    }

    public static Procedure getProcedureToRun(IProcedureManager procManager, IService service) throws Exception {
        String procedure_name = null;
        IEventDispatcher config = service.getConfig();
        config.fireEvent(E_DetectProcedure.EVENT_NAME, new Object[]{service});
        ServiceController controller = ServiceController
                .createServiceController(service.getServiceContext()
                        .getObjectContext());
        if (!controller.getContinueFlag())
            return null;
        procedure_name = controller.getProcedureName();
        Procedure proc = procManager.loadProcedure(procedure_name);
        return proc;
    }

    protected void doGet(HttpServletRequest request,
                         HttpServletResponse response) throws ServletException, IOException {
        doService(request, response);
    }

    protected void doPost(HttpServletRequest request,
                          HttpServletResponse response) throws ServletException, IOException {
        doService(request, response);
    }

    protected void checkParameters(HttpServletRequest request) throws ServletException {
        Map<String, String[]> parameterMap = request.getParameterMap();
        Iterator<Map.Entry<String, String[]>> iterator = parameterMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> it = iterator.next();
            if (it.getValue() != null && it.getValue()[0].indexOf("<script>") != -1) {
                throw new ServletException("parameter contain illegal value:" + it.getValue()[0].toString());
            }
            if(it.getKey().equals("_request_data")&&!it.getValue()[0].isEmpty()){
                JSONObject requestData = new JSONObject(it.getValue()[0]);
                if(requestData.has("parameter")){
                    JSONObject paraOject=requestData.getJSONObject("parameter");
                    if (paraOject.has("trx_id")){
                        String trx_id=paraOject.get("trx_id").toString().toLowerCase();
                        if(trx_id.indexOf("and") != -1||
                                trx_id.indexOf("or") != -1||
                                trx_id.indexOf("=") != -1||
                                trx_id.indexOf("select") != -1||
                                trx_id.indexOf("union") != -1||
                                trx_id.indexOf("<") != -1||
                                trx_id.indexOf(">") != -1||
                                trx_id.indexOf("+") != -1||
                                trx_id.indexOf("-") != -1){
                            throw new RuntimeException("parameter contain illegal value:" + trx_id);
                        }
                    }
                }



            }
        }
    }

    public void setButtonFilter(HttpServletRequest request) {
        ListCompositeMapRedisCache sysButtonAuthorityCache = SpringContextHolder.getBean("sysButtonAuthorityCache");
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        Object userIdObj = session.getAttribute("user_id");
        String userId = userIdObj == null ? null : userIdObj.toString();
        Object roleIdObj = session.getAttribute("role_id");
        String roleId = roleIdObj == null ? null : roleIdObj.toString();
        String functionCode = request.getParameter("function_code");
        String url = request.getRequestURI().replace(request.getContextPath() + "/", "");
        String key = "" + "." + roleId + "." + functionCode + "." + "";
        List<CompositeMap> buttonFilters = sysButtonAuthorityCache.getValue(key);
        if (buttonFilters == null) {
            key = userId + "." + roleId + "." + functionCode + "." + "";
            buttonFilters = sysButtonAuthorityCache.getValue(key);
            if (buttonFilters == null) {
                key = "" + "." + roleId + "." + functionCode + "." + url;
                buttonFilters = sysButtonAuthorityCache.getValue(key);
                if (buttonFilters == null) {
                    key = userId + "." + roleId + "." + functionCode + "." + url;
                    buttonFilters = sysButtonAuthorityCache.getValue(key);
                }
            }
        }
        if (buttonFilters != null && buttonFilters.size() > 0) {
            CompositeMap buttonFilter = buttonFilters.get(0);
            String buttonFilterStr = buttonFilter.getString("button_filter");
            request.setAttribute("buttonFilter", buttonFilterStr);
        } else {
            request.setAttribute("buttonFilter", null);
        }
    }

    protected void doService(HttpServletRequest request,
                             HttpServletResponse response) throws ServletException, IOException {
        // for activiti
        RequestHelper.setCurrentRequest(RequestHelper.createServiceRequest(request));
        ServletWebRequest servletWebRequest = new ServletWebRequest(request);
        RequestContextHolder.setRequestAttributes(servletWebRequest);
        // end activiti
        writeCacheDirection(response, null);
        HttpSession session = request.getSession(false);
        checkParameters(request);
        setButtonFilter(request);
        if (session != null) {
            Object csrfObject = request.getAttribute(CsrfToken.class.getName());
            if (csrfObject != null) {
                session.setAttribute("_csrf.token", ((CsrfToken) csrfObject).getToken());
            }
        }
        // check if UncertainEngine is inited properly
        if (!mUncertainEngine.isRunning()) {
            StringBuffer msg = new StringBuffer("Application failed to initialize");
            Throwable thr = mUncertainEngine.getInitializeException();
            if (thr != null)
                msg.append(":").append(thr.getMessage());
            response.sendError(500, msg.toString());
            return;
        }

        // create transaction
        UserTransaction trans = null;
        IObjectRegistry or = mUncertainEngine.getObjectRegistry();
        ITransactionService ts = (ITransactionService) or
                .getInstanceOfType(ITransactionService.class);
        if (ts == null)
            throw new ServletException("ITransactionService instance not found");
        trans = ts.getUserTransaction();

        // begin service
        StackTraceManager stm = new StackTraceManager();
        request.setCharacterEncoding("UTF-8");//form post encoding
        IService svc = null;
        ServiceContext ctx = null;
        boolean is_success = true;

        try {
            trans.begin();
            svc = createServiceInstance(request, response);
            ctx = svc.getServiceContext();
            ctx.setStackTraceManager(stm);
            ServiceThreadLocal.setCurrentThreadContext(ctx.getObjectContext());
            ServiceThreadLocal.setSource(request.getRequestURI());
            populateService(request, response, svc);
            writeCacheDirection(response, svc);

            Procedure pre_service_proc = null;

            if (mProcRegistry != null) {
                pre_service_proc = mProcRegistry.getProcedure(PRE_SERVICE);
                //post_service_proc = mProcRegistry.getProcedure(POST_SERVICE);
            }


            if (pre_service_proc != null)
                is_success = svc.invoke(pre_service_proc);

            if (is_success) {
                Procedure proc = getProcedureToRun(mProcManager, svc);
                if (proc != null) {
                    if (svc instanceof IConfigurableService) {
                        IConfigurableService cfsvc = (IConfigurableService) svc;
                        if (!cfsvc.isConfigParsed())
                            cfsvc.parseConfig();
                    }
                    is_success = svc.invoke(proc);
                    if (ctx.hasError())
                        is_success = false;
                }
            }

        } catch (Throwable ex) {
            is_success = false;
            mUncertainEngine.logException("Error when executing service "
                    + request.getRequestURI(), ex);
            handleException(request, response, ex);
        } finally {
            if (trans instanceof UserTransactionImpl) {
                if (svc == null)
                    throw new RuntimeException("svc is null");
                if (svc.getServiceContext() == null)
                    throw new RuntimeException("svc.getServiceContext() is null");
                ((UserTransactionImpl) trans).setContext(svc.getServiceContext().getObjectContext());
            }
            if (is_success) {
                try {
                    trans.commit();
                } catch (Throwable e) {
                    mUncertainEngine.logException("Error when commit service "
                            + request.getRequestURI(), e);
                }
            } else {
                try {
                    trans.rollback();
                } catch (Throwable e) {
                    mUncertainEngine.logException(
                            "Error when rollback service "
                                    + request.getRequestURI(), e);
                }
            }

            // release resource
            svc.release();

            // set overall finish time
            TraceElement elm = stm.getRootNode();
            if (elm != null)
                elm.setExitTime(System.currentTimeMillis());
            //System.out.println(elm.asCompositeMap().toXML());

            // fire ServiceFinish event
            if (svc != null)
                if (svc.getConfig() != null)
                    try {
                        svc.getConfig().fireEvent(E_ServiceFinish.EVENT_NAME, new Object[]{svc});
                    } catch (Throwable ex) {
                        mUncertainEngine.logException("Error when fire ServiceFinish", ex);
                    }

            ServiceThreadLocal.remove();
            cleanUp(svc);
            ts.stop();

        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        mConfig = config;
        mContext = config.getServletContext();
        mUncertainEngine = WebContextInit.getUncertainEngine(mContext);
        if (mUncertainEngine == null)
            throw new ServletException("Uncertain engine not initialized");
        mProcManager = mUncertainEngine.getProcedureManager();

        mProcRegistry = (IProcedureRegistry) mUncertainEngine
                .getObjectRegistry()
                .getInstanceOfType(IProcedureRegistry.class);

        // get global service config
        IObjectRegistry reg = getObjectRegistry();
        IParticipantManager pm = (IParticipantManager) reg.getInstanceOfType(IParticipantManager.class);
        if (pm != null) {
            mGlobalServiceConfig = pm.getParticipantsAsConfig("service");
        }
    }

    public UncertainEngine getUncertainEngine() {
        return mUncertainEngine;
    }

    public IObjectRegistry getObjectRegistry() {
        return mUncertainEngine == null ? null : mUncertainEngine.getObjectRegistry();
    }

    public Configuration getGlobalServiceConfig() {
        return mGlobalServiceConfig;
    }

}
