/*
* author:huangtianyang
* */
if (!HapHty) {
    var HapHty = {};
    !function (window, document, undefined) {
        Date.prototype.formatHty = function (fmt) {
            var o = {
                "M+": this.getMonth() + 1,                 //月份
                "d+": this.getDate(),                    //日
                "h+": this.getHours(),                   //小时
                "m+": this.getMinutes(),                 //分
                "s+": this.getSeconds(),                 //秒
                "q+": Math.floor((this.getMonth() + 3) / 3), //季度
                "S": this.getMilliseconds()             //毫秒
            };
            if (/(y+)/.test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
            }
            for (var k in o) {
                if (new RegExp("(" + k + ")").test(fmt)) {
                    fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
                }
            }
            return fmt;
        }

        function Submit(datas, grids, type, url, success) {

            this.datas = datas;
            this.grids = grids;
            this.type = type;
            this.url = url;
            this.success = success;
            this.init();
        }

        Submit.prototype = {
            init: function () {
                this._dataOperate();
            },
            _dataOperate: function () {

                this._setGridData();
                //datas转驼峰
                this.datas = this.humpObject(this.datas);
                console.log(this.gridDatas);
                this.ajaxData = $jq.extend({}, this.datas);
                for (var i = 0; i < this.gridDatas.length; i++) {
                    this.gridDatas[i] = this.humpObject(this.gridDatas[i]);
                    $jq.extend(this.ajaxData, this.gridDatas[i]);
                }
                // this.ajaxData = $jq.extend({}, this.datas, this.gridDatas);
                this._sendMsg();
            },
            humpObject: function (obj) {
                var humpObj = {};
                for (var key in obj) {
                    humpObj[HapHty.toHump(key)] = obj[key];
                }
                return humpObj;
            },
            _setGridData: function () {
                var opt = this;
                this.gridDatas = this.grids.map(function (val) {
                    var obj = {};
                    for (var key in val) {
                        obj[key] = val[key].data.map(function (value) {
                            var result = {};
                            $jq.extend(result, value.data);
                            //替换下划线为驼峰。jhf
                            result = opt.humpObject(result);
                            result['__status'] = 'clean';
                            if (value.dirty) {
                                switch (true) {
                                    //todo 增删
                                }
                                if (value.modified) {
                                    result['__status'] = 'update';
                                }
                            }
                            return result;
                        })
                    }
                    return obj;
                })
            },
            _sendMsg: function () {

                switch (this.type.toUpperCase()) {
                    case 'POST':
                        $jq.ajax({
                            url: this.url,
                            type: this.type,
                            contentType: 'application/json;charset=utf-8',
                            data: JSON.stringify(this.ajaxData),
                            success: this.success
                        });
                        break;
                    case 'GET':
                        //todo get
                        break;
                }
            }
        };


        function HapMaker() {
            var header = $jq('meta[name=_csrf_header]').attr('content');
            var token = $jq('meta[name=_csrf]').attr('content');
            $jq(document).ajaxSend(function (e, xhr, options) {
                xhr.setRequestHeader(header, token);
            });
        }


        HapMaker.prototype = {
            //转驼峰
            toHump: function (name) {
                return name.replace(/\_(\w)/g, function (all, letter) {
                    return letter.toUpperCase();
                });
            },
            //转下划线
            toLine: function (name) {
                return name.replace(/([A-Z])/g, "_$1").toLowerCase();
            },
            humpObject: function (obj) {
                var humpObj = {};
                for (var key in obj) {
                    humpObj[this.toHump(key)] = obj[key];
                }
                return humpObj;
            },
            submitForm: function (datas, grids, type, url, success) {
                new Submit(datas, grids, type, url, success);
            },
            submitGrid: function (datas, type, url, success, toObject) {
                var data = this._gridDataOperate(datas);
                if (toObject) {
                    data = {data: data};
                }
                switch (type.toUpperCase()) {
                    case "POST":
                        $jq.ajax({
                            url: url,
                            type: type,
                            contentType: 'application/json;charset=utf-8',
                            data: JSON.stringify(data),
                            success: success
                        });
                        break;
                    case "GET":
                        //todo
                        break;
                }
            },
            _gridDataOperate: function (datas) {
                var opt = this;
                var data = datas.map(function (value) {
                    return opt.humpObject(value.data);
                });

                for (var i = 0; i < datas.length; i++) {
                    data[i]['__status'] = 'query';
                    if (datas[i].modified) {
                        data[i]['__status'] = 'update';
                    }
                    if (datas[i].isNew) {
                        data[i]['__status'] = 'add';
                    }
                }
                return data;
            },
            //转格林尼治时间为北京时间
            formatHls3vDate: function (date) {

                if (date) {

                    return new Date(date).formatHty('yyyy-MM-dd hh:mm:ss');

                }
            }
        };

        HapHty = new HapMaker();
    }(window, document);
}

