
var queryTimeSolt = null  ,contractType = null;
function throwAmountPercent(params) {
    $jq.ajax({
        type: 'GET',
        url: contextPath + "/con/conHomepage/throwAmountPercent/query"+params,
        async: false, //设为同步
        contentType: "application/json; charset=utf-8",
        success: function (datas) {
            var receivedThrowTotalAmountEle = document.getElementById("receivedThrowTotalAmountId");
            if (datas && datas.throwTotalAmount && Number(datas.throwTotalAmount) != 0) {
                if(!datas.receivedThrowTotalAmount) datas.receivedThrowTotalAmount = 0;
                receivedThrowTotalAmountEle.innerHTML = parcentConvert(datas.receivedThrowTotalAmount / datas.throwTotalAmount);
                receivedThrowTotalAmountEle.style.width = parcentConvert(datas.receivedThrowTotalAmount/ datas.throwTotalAmount);
                document.getElementById("throwTotalAmountId").innerHTML = formatCurrency(datas.throwTotalAmount);
                document.getElementById("noThrow").innerHTML = formatCurrency(minus((datas.throwTotalAmount),datas.receivedThrowTotalAmount));
                document.getElementById("receivedThrow").innerHTML = formatCurrency(datas.receivedThrowTotalAmount);
            }else{
                receivedThrowTotalAmountEle.innerHTML = "0%";
                receivedThrowTotalAmountEle.style.width = "0px";
                document.getElementById("throwTotalAmountId").innerHTML = '0';
                document.getElementById("noThrow").innerHTML = '0';
                document.getElementById("receivedThrow").innerHTML = '0';
            }
        }
    });
}


var throwInitiateDonutChart = function () {
    return {
        init: function (element_v, datas) {
            var Donut = Morris.Donut({
                element: element_v,
                data: datas,
                colors: ['#2EC3E8', '#FFCD55', '#FA6A4D', '#A0D469'],
                formatter: function (y) {
                    return y;
                }
            });
            Donut.handlers = Donut.handlers || {};
            Donut.handlers.click = Donut.handlers.click || [];
            Donut.handlers.click.push(function (arg, arg1) {
                var contractStatus = '';
                if (arg1.label == "新建") {
                    contractStatus = "NEW";
                } else if (arg1.label == "审批通过") {
                    contractStatus = "APPROVED";
                } else if (arg1.label == "审批拒绝") {
                    contractStatus = "REJECTED";
                } else if (arg1.label == "审批中") {
                    contractStatus = "APPROVING";
                }

                throwApplyGrid(convertToURLString({paymentReqStatus:contractStatus}));

            });


        }
    };
}();


//投放信息-合同审批状态
function contractApprovalStatus(throwUrlParms) {
    var url = contextPath + "/con/conHomepage/ApprovalQuantity/query";
    if (throwUrlParms) {
        url = url + throwUrlParms;
    }

    $jq.ajax({
        type: 'GET',
        url: url,
        async: false,
        contentType: "application/json; charset=utf-8",
        success: function (datas) {
            var approvalStatus = null;
            if (!datas) {
                approvalStatus =
                {label: '新建', value: 0},
                {label: '审批中', value: 0},
                {label: '审批拒绝', value: 0},
                {label: '审批通过', value: 0}
            } else {
                approvalStatus = [
                    {label: '新建', value: datas.newCount},
                    {label: '审批中', value: datas.approvingCount},
                    {label: '审批拒绝', value: datas.rejectedCount},
                    {label: '审批通过', value: datas.approvedCount}
                ];
            }
            throwInitiateDonutChart.init('throwStatus', approvalStatus);
        }
    });
}

function throwDetailList(throwUrlParms) {
    var url = contextPath + "/con/conHomepage/details/query";
    if (throwUrlParms) {
        url = url + throwUrlParms;
    }

    $jq.ajax({
        type: 'GET',
        url: url,
        async: false, //设为同步
        contentType: "application/json; charset=utf-8",
        success: function (datas) {
            var throwDetailBar = document.getElementById("throwDetailBar");
            if (!throwDetailBar || !datas || datas.rows.length < 1)return false;

            //删除所有子节点
            var $jqthrowDetailBar = $jq("#throwDetailBar");
            var len = $jqthrowDetailBar.children().length;
            for (var j = 1; j < len; j++) {
                $jqthrowDetailBar.children().last().remove();
            }
            for (var i = 0; i < datas.rows.length; i++) {
                var outDiv = document.createElement("div");
                var h = document.createElement("strong");
                var innerDiv = document.createElement("div");
                innerDiv.setAttribute("class", "notice-font");
                outDiv.setAttribute("class", "notice_row border-bottom-1 postion-relative section-row-height");
                h.innerHTML = datas.rows[i].contractName;
                innerDiv.innerHTML =
                    "<span class='throw-notice'>" + Hls.formatDate(datas.rows[i].writeOffDate) + "</span>" + formatCurrency(datas.rows[i].writeOffDueAmount);
                outDiv.appendChild(h);
                outDiv.appendChild(innerDiv);
                throwDetailBar.appendChild(outDiv);
            }
        }
    });
}




function throwApplyGrid(throwUrlParms) {
    var throw_url = contextPath + "/csh/CshPaymentReqLn/queryLaunchApp/query"
    if(throwUrlParms)
        throw_url = throw_url + throwUrlParms;
    var throw_divgrid = document.getElementById("throwInfoGrid");
    gridQuery(throw_url, throw_divgrid);
}






function prepareQueryParam(){
    var tOneWeekTime = document.getElementById("tOneWeekTime").getAttribute("titleTip");
    var tOneMonthTime = document.getElementById("tOneMonthTime").getAttribute("titleTip");
    var tThreeMonthTime = document.getElementById("tThreeMonthTime").getAttribute("titleTip");
    //var tTimeInfinite = document.getElementById("tTimeInfinite").getAttribute("titleTip");
    if (tOneWeekTime == "selected") {
        queryTimeSolt = 7;
    } else if (tOneMonthTime == "selected") {
        queryTimeSolt = 30;
    } else if (tThreeMonthTime == "selected") {
        queryTimeSolt = 90;
    }
    //合同类型查询条件
    var tLeaseBack = document.getElementById("tLeaseBack").getAttribute("titleTip");
    var tDirect = document.getElementById("tDirect").getAttribute("titleTip");
    if (tLeaseBack == "selected" && tDirect != "selected") {
        contractType = "CONL";
    } else if (tDirect == "selected" && tLeaseBack != "selected") {
        contractType = "CONLB";
    } else {
        contractType = null;
    }
}

//查询事件
function throwSearchAction() {
    prepareQueryParam();
    var purl = contextPath + "/con/conHomepage/putIn/query?queryTimeSolt=" + queryTimeSolt + "&documentType=" + contractType;
    graphExam._init({
        topContBlock: {
            dataSouceUrl: purl
        },
        xValue: queryTimeSolt,
        mainContDataSourceUrl: purl
    });
    throwApplyGrid(convertToURLString({documentType:contractType,queryTimeSolt:queryTimeSolt}));
    throwAmountPercent(convertToURLString({documentType:contractType,queryTimeSolt:queryTimeSolt}));
    throwDetailList(convertToURLString({documentType:contractType,queryTimeSolt:queryTimeSolt}));//投放明细
}

function sparklineGraph(options) {
    this._init(options);
}
$jq.extend(sparklineGraph.prototype,
    {
        _init: function (options) {
            var self = this;
            if (!self.options) {
                self.options = {};
            }
            $jq.extend(true, self.options, options);
            self._initDomEvent();
            self._initTopCont();
            self._initMainGraphCont();
            self._initBottomBar();
            self._initClickLink();
        },
        _initDomEvent: function () {
            var opts = this.options;
            this.$jqgraph = $jq(opts.graphSelector);
            this.$jqtopCont = $jq(opts.topContBlock.topContSelector);
            this.$jqbottomCont = $jq(opts.bottomContSelector);
        },
        _initTopCont: function () {
            var self = this;

            var queryUrl = self.options.topContBlock.dataSouceUrl;
            $jq.get(queryUrl, function (datas, status) {
                if (datas && datas.rows[0]) {
                    var sumAcount = 0;
                    for (var i = 0; i < datas.rows.length; i++) {
                        sumAcount = plus(sumAcount, datas.rows[i].transactionAmount);
                    }
                    self.$jqtopCont.html(formatCurrency(sumAcount.toFixed(2)));
                } else {
                    self.$jqtopCont.html('￥0.00');
                }
            });
        },
        _initMainGraphCont: function () {
            var self = this;
            var queryUrl = self.options.mainContDataSourceUrl;
            var timeAcount = self.options.xValue;
            $jq.get(queryUrl, function (datas, status) {
                var content = [];
                if(!datas ){
                   content = new Array(timeAcount+1);
                    var cont = content.join(0+',');
                    self.$jqgraph.text(cont.substr(0,cont.length-1));
                }else{
                    var previousDate = self.getTheDate(self.getCurrentTime(), -timeAcount);
                    self.options.timeArray = [];
                    for (var i = 0; i <= timeAcount + 1; i++) {
                        var temp = 0;
                        for (var j = 0; j < datas.rows.length; j++) {
                            if (/\d{4}-\d{1,2}-\d{1,2}/g.exec(datas.rows[j].transactionDate) == previousDate) {
                                console.log(datas.rows[j].transactionAmount);
                                temp += datas.rows[j].transactionAmount;
                            }
                            console.log('/');
                        }
                        self.options.timeArray.push(previousDate);
                        content.push(temp);
                        previousDate = self.getTheDate(previousDate, 1);
                    }
                    content = content.toString();
                    self.$jqgraph.text(content);
                }
                InitiateSparkline2Charts.init();

            });
        },
        _initBottomBar: function () {
            var self = this;
            var days = self.options.xValue;
            var sysDateStr = self.getCurrentTime();
            if (days <= 7) {
                var dayNames = new Array("星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六");
                var newDate = new Date();
                newDate.setDate(newDate.getDate() - 6);
                self.createBottomBarNode(7, "week");
                var spanGather = self.$jqbottomCont.find("span");
                $jq.each(spanGather, function (index) {
                    if (index == spanGather.length - 1) {
                        $jq(this).text(dayNames[newDate.getDay()] + "(ToDay)");
                    } else {
                        $jq(this).text(dayNames[newDate.getDay()]);
                    }
                    newDate.setDate(newDate.getDate() + 1);
                })
            }
            else if (days <= 30) {
                self.createBottomBarNode(7, "oneMonth");
                $jq('#day-7').text(sysDateStr);
                var previousDate = self.getTheDate(sysDateStr, -5);
                for (var k = 6; 0 < k; k--) {
                    $jq('#day-' + k).text(previousDate);
                    previousDate = self.getTheDate(previousDate, -5);
                }
            }
            else {
                self.createBottomBarNode(7, "threeMonth");
                $jq('#day-7').text(sysDateStr);
                var previousDate = self.getTheDate(sysDateStr, -14);
                for (var k = 6; 0 < k; k--) {
                    $jq('#day-' + k).text(previousDate);
                    previousDate = self.getTheDate(previousDate, -14);
                }
            }
        },
        _initClickLink: function () {
            var self = this;
            self.$jqgraph.bind('click', function (ev) {
                prepareQueryParam();
                throwDetailList(convertToURLString({strDate:self.options.mousePosTime,queryTimeSolt:queryTimeSolt,contractType:contractType}));
            });
            self.$jqgraph.bind('sparklineRegionChange', function (ev) {
                var sparkline = ev.sparklines[0];
                var region = sparkline.getCurrentRegionFields();
                var value = region.y;
                var x = region.x;
                if(self.options.timeArray){
                    self.options.mousePosTime = self.options.timeArray[x];
                }
            });
        },
        getCurrentTime: function () {
            var date = new Date();
            return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
        },
        getTheDate: function (dd, dadd) {
            var a = null;
            if(typeof dd  !=  'object'){
                a = new Date(dd.replace(/-/g, "/"));
            }else{
                a = dd;
            }
            a = a.valueOf()
            a = a + dadd * 24 * 60 * 60 * 1000
            a = new Date(a);
            var m = a.getMonth() + 1;
            if (m.toString().length == 1) {
                m = '0' + m;
            }
            var d = a.getDate();
            if (d.toString().length == 1) {
                d = '0' + d;
            }
            return a.getFullYear() + "-" + m + "-" + d;
        },
        createBottomBarNode: function (sum, type) {
            var self = this;
            var class1 = "databox-cell cell-2 text-align-center no-padding padding-top-5";
            var class2 = "databox-header white";
            var parentDiv = self.$jqbottomCont[0];
            $jq(parentDiv).empty();
            for (var i = 0; i < sum; i++) {
                var cDiv = document.createElement("div");
                cDiv.setAttribute("class", class1);
                var cSpan = document.createElement("span");
                cSpan.setAttribute("class", class2);
                var cId = i + 1;
                cId = "day-" + cId;
                cSpan.setAttribute("id", cId);

                if (type == "week") {
                    cDiv.style.width = "14.28%";
                    cSpan.style.fontSize = "14px";
                }
                else if (type == "oneMonth" || type == "threeMonth") {
                    cDiv.style.width = "14.28%";
                    cSpan.style.fontSize = "12px";
                }
                cDiv.appendChild(cSpan);
                parentDiv.appendChild(cDiv);
            }
        }
    });

//投放明细弹框
function addFunction(payment_req_id) {

    Hls.openBox(
        {
            functionCode: "CSH220B",
            winId: "throwDetailDialog",
            params: {
                payment_req_ln_id:payment_req_id
            }
        }
    );

}

//投放明细+号事件
function paymentCreatePop() {
    top.openTab('PAYMENT_CREATE', '付款新建', contextPath + '/csh/CSH200/payment_creates.view');
}

var graphExam = null;
function throwInfoClickEvent() {
    throwApplyGrid(convertToURLString({queryTimeSolt:30}));//grid
    throwAmountPercent(convertToURLString({queryTimeSolt:30})); //百分比图
    contractApprovalStatus(convertToURLString({queryTimeSolt:30}));//投放情况图
    throwDetailList(convertToURLString({queryTimeSolt:30}));//投放明细
    graphExam = new sparklineGraph({
        graphSelector: "#contract-overdue-span",                        //传入控件选择器
        topContBlock: {
            topContSelector: "#con-overdue-total",
            dataSouceUrl: contextPath + "/con/conHomepage/putIn/query?queryTimeSolt=30"
        },                                                              //传入总金额选择器和url
        xValue: 30,                                                     //传入横轴的天数
        mainContDataSourceUrl: contextPath + "/con/conHomepage/putIn/query?queryTimeSolt=30",  //传入中间图形那查询的url,
        bottomContSelector: "#outDiv"
    });
}


