CREATE TABLE csh_transaction_plan(
       plan_id NUMBER,
       transaction_id NUMBER,
       write_off_type VARCHAR2(20),
       company_id number,
       bp_id NUMBER,
       write_off_amount NUMBER,
       write_off_date DATE,
       created_by NUMBER,
       creation_date DATE,
       last_updated_by NUMBER,
       last_update_date DATE
);
ALTER TABLE csh_transaction_plan
ADD CONSTRAINTS csh_transaction_plan_pk PRIMARY KEY (plan_id);

CREATE SEQUENCE csh_transaction_plan_s;

COMMENT ON TABLE csh_transaction_plan IS '保证金、预收款-收款单生成-核销计划';
COMMENT ON COLUMN csh_transaction_plan.plan_id IS 'pk';
COMMENT ON COLUMN csh_transaction_plan.company_id IS '公司ID';
COMMENT ON COLUMN csh_transaction_plan.transaction_id IS 'csh_transaction -- pk';
COMMENT ON COLUMN csh_transaction_plan.write_off_type IS '核销事务类型 （保证金/预收款）';
COMMENT ON COLUMN csh_transaction_plan.bp_id IS '商业伙伴ID -- 代理商（保证金）/商业伙伴（预收款）';
COMMENT ON COLUMN csh_transaction_plan.write_off_amount IS '核销金额';
COMMENT ON COLUMN csh_transaction_plan.write_off_date IS '核销日期';