﻿create or replace package con_contract_workflow_pkg is

  -- Author  : LIJINGJING
  -- Created : 2019/9/24 17:26:56
  -- Purpose : 
  procedure contract_submit(p_contract_id NUMBER, p_user_id NUMBER);

end con_contract_workflow_pkg;
/
create or replace package body con_contract_workflow_pkg is

  procedure contract_submit(p_contract_id NUMBER, p_user_id NUMBER) is
    v_contract_rec con_contract%ROWTYPE;
    v_contract_status_error exception;
    v_instance_id     number;
    v_approval_method hls_document_type.approval_method%Type;
  BEGIN
    SELECT *
      INTO v_contract_rec
      FROM con_contract cc
     WHERE cc.contract_id = p_contract_id;
    IF v_contract_rec.contract_status NOT IN ('NEW', 'RETURN') then
      RAISE v_contract_status_error;
    END IF;
      Select approval_method
      Into v_approval_method
      From hls_document_type
     Where document_category = v_contract_rec.document_category
       And document_type = v_contract_rec.document_type;
    --条件表调用工作流
    v_instance_id := v_contract_rec.wfl_instance_id;
    If v_approval_method = 'WORK_FLOW' Then
      hls_workflow_pkg.workflow_start(p_instance_id       => v_instance_id,
                                      p_document_category => 'CONTRACT',
                                      p_document_type     =>'CARCON',
                                      p_company_id        => v_contract_rec.company_id,
                                      p_user_id           => p_user_id,
                                      p_function_code     => '',
                                      p_parameter_1       => 'CONTRACT_ID',
                                      p_parameter_1_value => p_contract_id,
                                      p_parameter_2       => 'DOCUMENT_INFO',
                                      p_parameter_2_value => '合同审批' || '-' ||
                                                             v_contract_rec.contract_name || '-' ||
                                                             v_contract_rec.contract_number,
                                      p_parameter_3       => 'SUBMITTED_BY',
                                      p_parameter_3_value => p_user_id);
      UPDATE CON_CONTRACT T
         SET T.wfl_contract_status = 'APPROVING',
         t.wfl_instance_id=v_instance_id
       WHERE T.CONTRACT_ID = P_CONTRACT_ID;
    End If;
  
  EXCEPTION
    WHEN v_contract_status_error THEN
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => '只有新建和审批退回的单据才可以提交审批！！',
                                                     p_created_by              => p_user_id,
                                                     p_package_name            => 'con_contract_workflow_pkg',
                                                     p_procedure_function_name => 'contract_submit');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  END;
end con_contract_workflow_pkg;
/
