package com.hand.hls.hlcm.cont.util;

/**
 * @Author: Liyuan.Chen
 * @Date: 2020/8/19
 * @Purpose:
 */
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * excle样式工具类
 * @author linry
 *
 */
public class ExcelFormatUtil {
    /**
     * 设置报表头样式
     * @param workbook
     * @return
     */
    public static CellStyle headSytle(SXSSFWorkbook workbook){
        // 设置style1的样式，此样式运用在第二行
        CellStyle style1 = workbook.createCellStyle();// cell样式
        // 设置单元格背景色，设置单元格背景色以下两句必须同时设置
        /*style1.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);// 设置填充样式
        style1.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);// 设置填充色*/
        // 设置单元格上、下、左、右的边框线
        /*style1.setBorderBottom(HSSFCellStyle.BORDER_THIN);
        style1.setBorderLeft(HSSFCellStyle.BORDER_THIN);
        style1.setBorderRight(HSSFCellStyle.BORDER_THIN);
        style1.setBorderTop(HSSFCellStyle.BORDER_THIN);*/
        Font font1 = workbook.createFont();// 创建一个字体对象
        font1.setBold(true);
        //font1.setBoldweight((short) 16);// 设置字体的宽度
        font1.setFontHeightInPoints((short) 16);// 设置字体的高度
        font1.setFontName("等线");
        //font1.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// 粗体显示
        style1.setFont(font1);// 设置style1的字体
        style1.setWrapText(true);// 设置自动换行
        style1.setAlignment(HorizontalAlignment.CENTER);// 设置单元格字体显示居中（左右方向）
        style1.setVerticalAlignment(VerticalAlignment.CENTER);// 设置单元格字体显示居中(上下方向)
        return style1;
    }
    /**
     * 设置报表体样式
     * @param wb
     * @return
     */
    public static CellStyle contentStyle(SXSSFWorkbook wb){
        // 设置style1的样式，此样式运用在第二行
        CellStyle style1 = wb.createCellStyle();// cell样式
        // 设置单元格上、下、左、右的边框线
        /*style1.setBorderBottom(HSSFCellStyle.BORDER_THIN);
        style1.setBorderLeft(HSSFCellStyle.BORDER_THIN);
        style1.setBorderRight(HSSFCellStyle.BORDER_THIN);
        style1.setBorderTop(HSSFCellStyle.BORDER_THIN);*/
        //style1.setWrapText(true);// 设置自动换行
        style1.setAlignment(HorizontalAlignment.LEFT);// 设置单元格字体显示居中（左右方向）
        style1.setVerticalAlignment(VerticalAlignment.CENTER);// 设置单元格字体显示居中(上下方向)
        return style1;
    }

    public static CellStyle contentStyleLine(SXSSFWorkbook wb){
        // 设置style1的样式，此样式运用在第二行
        CellStyle style1 = wb.createCellStyle();// cell样式
        // 设置单元格上、下、左、右的边框线
        style1.setBorderBottom(BorderStyle.THIN);
       /* style1.setBorderBottom(HSSFCellStyle.BORDER_THIN);
        style1.setBorderLeft(HSSFCellStyle.BORDER_THIN);
        style1.setBorderRight(HSSFCellStyle.BORDER_THIN);
        style1.setBorderTop(HSSFCellStyle.BORDER_THIN);*/
        style1.setWrapText(true);// 设置自动换行
        style1.setAlignment(HorizontalAlignment.LEFT);// 设置单元格字体显示居中（左右方向）
        style1.setVerticalAlignment(VerticalAlignment.CENTER);// 设置单元格字体显示居中(上下方向)
        return style1;
    }

    public static CellStyle contentTableStyle(SXSSFWorkbook wb){
        // 设置style1的样式，此样式运用在第二行
        CellStyle style1 = wb.createCellStyle();// cell样式
        // 设置单元格上、下、左、右的边框线
        style1.setBorderBottom(BorderStyle.THIN);
        style1.setBorderLeft(BorderStyle.THIN);
        style1.setBorderRight(BorderStyle.THIN);
        style1.setBorderTop(BorderStyle.THIN);
        style1.setWrapText(true);// 设置自动换行
        style1.setAlignment(HorizontalAlignment.CENTER);// 设置单元格字体显示居中（左右方向）
        style1.setVerticalAlignment(VerticalAlignment.CENTER);// 设置单元格字体显示居中(上下方向)
        return style1;
    }
    /**
     * 设置报表标题样式
     * @param workbook
     * @return
     */
    public static HSSFCellStyle titleSytle(HSSFWorkbook workbook,short color,short fontSize){
        // 设置style1的样式，此样式运用在第二行
        HSSFCellStyle style1 = workbook.createCellStyle();// cell样式
        // 设置单元格背景色，设置单元格背景色以下两句必须同时设置
        //style1.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);// 设置填充样式
        //short fcolor = color;
        // 设置单元格上、下、左、右的边框线
        style1.setBorderBottom(BorderStyle.THIN);
        style1.setBorderLeft(BorderStyle.THIN);
        style1.setBorderRight(BorderStyle.THIN);
        style1.setBorderTop(BorderStyle.THIN);
        HSSFFont font1 = workbook.createFont();// 创建一个字体对象
        font1.setBold(true);
        font1.setFontHeightInPoints(fontSize);// 设置字体的高度
        style1.setFont(font1);// 设置style1的字体
        style1.setWrapText(true);// 设置自动换行
        style1.setAlignment(HorizontalAlignment.CENTER);// 设置单元格字体显示居中（左右方向）
        style1.setVerticalAlignment(VerticalAlignment.CENTER);// 设置单元格字体显示居中(上下方向)
        return style1;
    }
    /**
     *设置表头
     * @param sheet
     */
    public static void initTitleEX(SXSSFSheet sheet, CellStyle header,String title[],int titleLength[]) {

        SXSSFRow row0 = sheet.createRow(0);
        row0.setHeight((short) 800);
        for(int j = 0;j<title.length; j++) {
            SXSSFCell cell = row0.createCell(j);
            //设置每一列的字段名
            cell.setCellValue(title[j]);
            cell.setCellStyle(header);
            sheet.setColumnWidth(j, titleLength[j]);
        }
    }

    /**
     *设置表头
     * @param sheet
     */
    public static void initTitle(SXSSFSheet sheet, CellStyle header, String title, int firstRow, int firstrCol) {

        SXSSFRow row = sheet.createRow(firstRow);
        SXSSFCell cell = row.createCell(firstrCol);
        //设置每一列的字段名
        cell.setCellValue(title);
        cell.setCellStyle(header);
        CellRangeAddress region = new CellRangeAddress(firstRow, firstRow+1, firstrCol, 9);
        sheet.addMergedRegion(region);
    }



    public static void initContent(SXSSFSheet sheet, CellStyle contentType, String content, int firstRow, int firstrCol) {

        SXSSFRow row = sheet.createRow(firstRow);
        SXSSFCell cell = row.createCell(firstrCol);
        //设置每一列的字段名
        cell.setCellValue(content);
        cell.setCellStyle(contentType);
        CellRangeAddress region = new CellRangeAddress(firstRow, firstRow, firstrCol, 9);
        sheet.addMergedRegion(region);
    }


    public static void initColumn(SXSSFSheet sheet, CellStyle contentTable,String title[],int titleLength[], int firstRow) {

        SXSSFRow row = sheet.createRow(firstRow);
        for(int j = 1;j<=title.length; j++) {
            SXSSFCell cell = row.createCell(j);
            //设置每一列的字段名
            cell.setCellValue(title[j-1]);
            cell.setCellStyle(contentTable);
            sheet.setColumnWidth(j, titleLength[j-1]);
        }
    }

    public static BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal) value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String) value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger) value);
            } else if (value instanceof Number) {
                ret = new BigDecimal(((Number) value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }
}
