package com.hand.hls.hlcm.atm.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.atm.dto.HlsFndAtmAttachment;
import com.hand.hls.hlcm.atm.service.IHlsFndAtmAttachmentService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Controller
public class HlsFndAtmAttachmentController extends BaseController {

    @Autowired
    private IHlsFndAtmAttachmentService service;

    private static String ATTACHMENT_PATH = "/u01/hls_file/";

    @RequestMapping(value = "/fnd/atm/attachment/query")
    @ResponseBody
    public ResponseData query(HlsFndAtmAttachment dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/fnd/atm/attachment/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<HlsFndAtmAttachment> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/fnd/atm/attachment/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<HlsFndAtmAttachment> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value = "/hls_file/{filepath}")
    @ResponseBody
    public void downloadHlsFile(@PathVariable(value = "filepath") String filePath,
                                HttpServletResponse response, @RequestParam(defaultValue = "octet-stream") String type) {
        String file = StringUtils.join(ATTACHMENT_PATH, filePath);
        service.downloadAttachment(file, response, type);
    }


    @RequestMapping(value = "/hls_file/{filepath1}/{filepath2}")
    @ResponseBody
    public void downloadHlsFile(@PathVariable String filepath1, @PathVariable String filepath2,
                                HttpServletResponse response, @RequestParam(defaultValue = "octet-stream") String type) {

        String filePath = StringUtils.join(ATTACHMENT_PATH, filepath1, "/", filepath2);
        service.downloadAttachment(filePath, response, type);
    }

    @RequestMapping(value = "/hls_file/{filepath1}/{filepath2}/{filepath3}")
    @ResponseBody
    public void downloadHlsFile(@PathVariable String filepath1, @PathVariable String filepath2,
                                @PathVariable String filepath3, HttpServletResponse response, @RequestParam(defaultValue = "octet-stream") String type) {

        String filePath = StringUtils.join(ATTACHMENT_PATH, filepath1, "/", filepath2, "/", filepath3);
        service.downloadAttachment(filePath, response, type);
    }

    @RequestMapping(value = "/hls_file/{filepath1}/{filepath2}/{filepath3}/{filepath4}")
    @ResponseBody
    public void downloadHlsFile(@PathVariable String filepath1, @PathVariable String filepath2,
                                @PathVariable String filepath3, @PathVariable String filepath4,
                                HttpServletResponse response, @RequestParam(defaultValue = "octet-stream") String type) {

        String filePath = StringUtils.join(ATTACHMENT_PATH, filepath1, "/", filepath2, "/", filepath3, "/", filepath4);
        service.downloadAttachment(filePath, response, type);
    }
}