package com.hand.hls.hlcm.cont.service.impl;

import com.hand.hls.hlcm.cont.mapper.ConExportMapper;
import com.hand.hls.hlcm.cont.service.ConExportService;

/**
 * @Author: Liyuan.Chen
 * @Date: 2020/8/19
 * @Purpose:
 */

import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URL;
import java.net.URLEncoder;
import java.util.*;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.hand.hls.hlcm.cont.util.ExcelFormatUtil;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.*;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class ConExportServiceImpl implements ConExportService {
    //Logger logger = LoggerFactory.getLogger(ConExportServiceImpl.class);
    @Autowired
    private ConExportMapper conExportMapper;

    @Override
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, int contractId) {
        try {
            //logger.info(">>>>>>>>>>开始导出excel>>>>>>>>>>");

            // 造几条数据
            HashMap<String, Object> mapContract = conExportMapper.selectContractDetailList(contractId);
            LinkedList<LinkedHashMap<String, Object>> list = (LinkedList<LinkedHashMap<String, Object>>) conExportMapper.selectCashflowList(contractId);

            /*BaseFrontController baseFrontController = new BaseFrontController();
            return baseFrontController.buildResponseEntity(export((List<User>) list), "用户表.xls");*/
            export(mapContract, list, response);
        } catch (Exception e) {
            e.printStackTrace();
            //logger.error(">>>>>>>>>>导出excel 异常，原因为：" + e.getMessage());
        }
        //return null;
    }

    private void export(HashMap map, LinkedList list, HttpServletResponse response) {
        //logger.info(">>>>>>>>>>>>>>>>>>>>开始进入导出方法>>>>>>>>>>");
        SXSSFWorkbook wb = new SXSSFWorkbook(1000);// 保留1000条数据在内存中
        SXSSFSheet sheet = wb.createSheet();
        sheet.setDisplayGridlines(false);
        // 设置报表头样式

        BufferedImage bufferImg = null;
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        try {

            ClassLoader classLoader = this.getClass().getClassLoader();
            URL resource = classLoader.getResource("/");
            String path = resource.getPath();
            System.out.println(path);
            bufferImg = ImageIO.read(new File(path + "com/hand/hls/hlcm/cont/img/HonglingNew.jpg"));

            ImageIO.write(bufferImg, "jpg", byteArrayOut);
        } catch (IOException e) {
            e.printStackTrace();
        }

        //画图的顶级管理器，一个sheet只能获取一个（一定要注意这点）
        SXSSFDrawing patriarch = sheet.createDrawingPatriarch();
        //Drawing patriarch = sheet.createDrawingPatriarch();
        //anchor主要用于设置图片的属性
        XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 255, 255, (short) 3, 0, (short) 7, 3);
        anchor.setAnchorType(ClientAnchor.AnchorType.byId(3));
        //插入图片
        patriarch.createPicture(anchor, wb.addPicture(byteArrayOut.toByteArray(), HSSFWorkbook.PICTURE_TYPE_JPEG));
        CellRangeAddress regionTitle0 = new CellRangeAddress(0, 2, 0, 9);
        sheet.addMergedRegion(regionTitle0);

        CellStyle content = ExcelFormatUtil.contentStyle(wb);// 黑体居左显示
        CellStyle contentLine = ExcelFormatUtil.contentStyleLine(wb);// 黑体加下边框线显示
        CellStyle contentTable = ExcelFormatUtil.contentTableStyle(wb);// 等线居中加边框显示

        String contentTitle = "96 Ying Chun Road, Pudong New Area Shanghai, China 200127";
        SXSSFRow rowTitle = sheet.createRow(3);
        SXSSFCell cellTitle = rowTitle.createCell(3);
        cellTitle.setCellValue(contentTitle);
        cellTitle.setCellStyle(ExcelFormatUtil.contentCenterStyle(wb));// 黑体居中
        CellRangeAddress regionTitle = new CellRangeAddress(3, 3, 3, 6);
        sheet.addMergedRegion(regionTitle);

        contentTitle = "中国上海市浦东新区迎春路96号";
        SXSSFRow rowTitle1 = sheet.createRow(4);
        SXSSFCell cellTitle1 = rowTitle1.createCell(3);
        cellTitle1.setCellValue(contentTitle);
        cellTitle1.setCellStyle(ExcelFormatUtil.contentCenterStyle(wb));// 黑体居中
        CellRangeAddress regionTitle1 = new CellRangeAddress(4, 4, 3, 6);
        sheet.addMergedRegion(regionTitle1);

        contentTitle = "Tel:+86-(0)21-5056-3050\tFax:+86-(0)21-5056-3077";
        SXSSFRow rowTitle2 = sheet.createRow(5);
        SXSSFCell cellTitle2 = rowTitle2.createCell(3);
        cellTitle2.setCellValue(contentTitle);
        cellTitle2.setCellStyle(ExcelFormatUtil.contentCenterStyle(wb));// 黑体居中
        CellRangeAddress regionTitle2 = new CellRangeAddress(5, 5, 3, 6);
        sheet.addMergedRegion(regionTitle2);

        SXSSFRow rowTitle3 = sheet.createRow(6);
        for (int i = 0; i < 10; i++) {
            SXSSFCell cellTitle3 = rowTitle3.createCell(i);
            cellTitle3.setCellValue("");
            cellTitle3.setCellStyle(contentLine);
        }
        CellRangeAddress regionTitle3 = new CellRangeAddress(6, 6, 0, 9);
        sheet.addMergedRegion(regionTitle3);

        ExcelFormatUtil.initTitle(sheet, ExcelFormatUtil.headSytle(wb), "对账单", 7, 0);

        String contentExcel = "（承租人）" + map.get("BP_NAME");
        SXSSFRow rowBpName = sheet.createRow(10);
        SXSSFCell cellBpName = rowBpName.createCell(0);
        cellBpName.setCellValue(contentExcel);
        cellBpName.setCellStyle(ExcelFormatUtil.contentBpStyle(wb));// 这部分加粗居左显示
        sheet.setColumnWidth(0, 2000);

        /*String bpName = (String) map.get("BP_NAME");
        System.out.println(bpName);
        SXSSFCell cellBpValue = rowBpName.createCell(1);
        cellBpValue.setCellValue(bpName);
        cellBpValue.setCellStyle(contentLine);*/

        SXSSFCell cellBpValue1 = rowBpName.createCell(1);
        cellBpValue1.setCellValue("");
        cellBpValue1.setCellStyle(contentLine);

        SXSSFCell cellBpValue2 = rowBpName.createCell(2);
        cellBpValue2.setCellValue("");
        cellBpValue2.setCellStyle(contentLine);

        SXSSFCell cellBpValue3 = rowBpName.createCell(3);
        cellBpValue3.setCellValue("");
        cellBpValue3.setCellStyle(contentLine);

        SXSSFCell cellBpValue4 = rowBpName.createCell(4);
        cellBpValue4.setCellValue("：");
        cellBpValue4.setCellStyle(content);

        CellRangeAddress region = new CellRangeAddress(10, 10, 0, 3);
        sheet.addMergedRegion(region);

        contentExcel = "    依据您与宏菱融资租赁（上海）有限公司签订的《融资租赁合同》，（合同号：" +
                map.get("CONTRACT_NUMBER") + "；机号：" + map.get("MACHINE_NUMBER") + "）";
        ExcelFormatUtil.initContent(sheet, content, contentExcel, 12, 0);

        contentExcel = "我公司已经按约向您交付了租赁物，截止" +
                map.get("TODAY") + "，您已支付我公司以下性质和金额的款项：";
        ExcelFormatUtil.initContent(sheet, content, contentExcel, 14, 0);

        sheet.setColumnWidth(9, 3000);
        if (list != null && list.size() > 1) {
            //logger.info(">>>>>>>>>>>>>>>>>>>>开始遍历数据组装单元格内容>>>>>>>>>>");

            // 每一列字段名
            String[] strs = new String[]{"款项性质", "期次", "约定支付日", "应付金额", "实际收款日", "收款金额", "实收违约金", "未收金额"};
            // 字段名所在表格的宽度
            int[] ints = new int[]{2500, 1800, 3000, 3000, 3000, 3000, 3000, 3000};

            // 设置表头样式
            ExcelFormatUtil.initColumn(sheet, contentTable, strs, ints, 16);
            //logger.info(">>>>>>>>>>>>>>>>>>>>表头样式设置完成>>>>>>>>>>");

            for (int i = 0; i < list.size(); i++) {

                LinkedHashMap<String, Object> map1 = (LinkedHashMap<String, Object>) list.get(i);
                SXSSFRow row = sheet.createRow(i + 17);
                int j = 1;

                SXSSFCell cell = row.createCell(j++);
                if (map1.get("CF_ITEM_N") != null) {
                    cell.setCellValue((String) map1.get("CF_ITEM_N")); // 款项性质
                } else {
                    cell.setCellValue(""); // 款项性质
                }
                cell.setCellStyle(contentTable);

                cell = row.createCell(j++);
                if (map1.get("TIMES") != null) {
                    cell.setCellValue(ExcelFormatUtil.getBigDecimal(map1.get("TIMES")).toString()); // 期次
                } else {
                    cell.setCellValue(""); // 期次
                }
                cell.setCellStyle(contentTable);

                cell = row.createCell(j++);
                if (map1.get("DUE_DATE") != null) {
                    cell.setCellValue((String) map1.get("DUE_DATE")); // 应付日
                } else {
                    cell.setCellValue(""); // 应付日
                }
                cell.setCellStyle(contentTable);

                cell = row.createCell(j++);
                if (map1.get("DUE_AMOUNT") != null) {
                    cell.setCellValue((String) map1.get("DUE_AMOUNT")); // 应付金额
                } else {
                    cell.setCellValue(""); // 应付金额
                }
                cell.setCellStyle(contentTable);

                cell = row.createCell(j++);
                if (map1.get("TRANSACTION_DATE") != null) {
                    cell.setCellValue((String) map1.get("TRANSACTION_DATE")); // 实际收款日
                } else {
                    cell.setCellValue(""); // 实际收款日
                }
                cell.setCellStyle(contentTable);

                cell = row.createCell(j++);
                if (map1.get("RECEIVED_AMOUNT") != null) {
                    cell.setCellValue((String) map1.get("RECEIVED_AMOUNT")); // 收款金额
                } else {
                    cell.setCellValue(""); // 收款金额
                }
                cell.setCellStyle(contentTable);

                cell = row.createCell(j++);
                if (map1.get("RECEIVED_AMOUNT_9") != null) {
                    cell.setCellValue((String) map1.get("RECEIVED_AMOUNT_9")); // 实收违约金
                } else {
                    cell.setCellValue(""); // 实收违约金
                }
                cell.setCellStyle(contentTable);

                cell = row.createCell(j++);
                if (map1.get("UNRECEIVED_AMOUNT") != null) {
                    cell.setCellValue((String) map1.get("UNRECEIVED_AMOUNT")); // 未收金额
                } else {
                    cell.setCellValue(""); // 未收金额
                }
                cell.setCellStyle(contentTable);
            }
        }
        //logger.info(">>>>>>>>>>>>>>>>>>>>结束遍历数据组装单元格内容>>>>>>>>>>");

        contentExcel = "由于入账处理需要时间，以上还款金额可能未包含最近一次的还款记录。";
        ExcelFormatUtil.initContent(sheet, content, contentExcel, list.size() + 16 + 2, 1);

        contentExcel = "请参考。";
        ExcelFormatUtil.initContent(sheet, content, contentExcel, list.size() + 16 + 4, 1);

        contentExcel = "宏菱融资租赁（上海）有限公司";
        ExcelFormatUtil.initContent(sheet, ExcelFormatUtil.contentCenterStyle(wb), contentExcel, list.size() + 16 + 6, 6);

        contentExcel = "（公章）";
        ExcelFormatUtil.initContent(sheet, ExcelFormatUtil.contentCenterStyle(wb), contentExcel, list.size() + 16 + 8, 6);

        contentExcel = (String) map.get("TODAY");
        ExcelFormatUtil.initContent(sheet, ExcelFormatUtil.contentCenterStyle(wb), contentExcel, list.size() + 16 + 10, 6);
        try {
            outputResponse(response, wb, "对账单（" + (String) map.get("BP_NAME") + (String) map.get("CONTRACT_NUMBER") + "）.xlsx");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputResponse(HttpServletResponse response, SXSSFWorkbook sheets, String fileName) throws IOException {
        response.addHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\"");
        response.setContentType(sheets.getXSSFWorkbook().getWorkbookType().getContentType() + ";charset=" + "UTF-8");
        response.setHeader("Accept-Ranges", "bytes");
        sheets.write(response.getOutputStream());
        sheets.dispose();
    }

}
