package com.hand.hap.generator.service.impl;

import com.hand.hap.generator.dto.DBColumn;
import com.hand.hap.generator.dto.DBTable;

import java.io.*;
import java.util.Date;
import java.util.List;

/**
 * @author: hty  Date: 2018/4/28 Time: 11:48
 */
public class AuroraUtil {

    /**
     * 根据数据库表生成BM文件
     *
     * @param location 文件位置
     * @param fileName 文件名
     * @param table    表名
     **/
    public static void createBMFile(String location, String fileName, DBTable table, List<String> columnNames) throws IOException {
        File file = new File(location + "/" + fileName + ".bm");
        //文件路径是否存在，不存在则创建路径
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        List<DBColumn> columns = table.getColumns();
        for (DBColumn s : columns) {
            switch (s.getJdbcType().toUpperCase()) {
                case "DATE":
                case "TIMESTAMP":
                case "DATETIME":
                case "TIME":
                    s.setDataType("java.util.Date");
                    s.setJavaType("DATE");
                    break;
                case "BIGINT":
                case "INT":
                case "INTEGER":
                case "DECIMAL":
                case "TINYINT":
                case "NUMBER":
                    s.setDataType("java.lang.Long");
                    s.setJavaType("DECIMAL");
                    break;
                case "DOUBLE":
                    s.setDataType("java.lang.Double");
                    s.setJavaType("DECIMAL");
                    break;
                case "FLOAT":
                    s.setDataType("java.lang.Float");
                    s.setJavaType("DECIMAL");
                    break;
                default:
                    s.setDataType("java.lang.String");
                    s.setJavaType("VARCHAR");
                    break;
            }
        }
        //写入内容
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        sb.append("<!--\n" +
                "    $Author: Aurora Generator  \n" +
                "    $Date: " + new Date().toString() + "  \n" +
                "    $Revision: 1.0  \n" +
                "    $Purpose: \n" +
                "-->\r\n");
        sb.append("<bm:model xmlns:bm=\"http://www.aurora-framework.org/schema/bm\" xmlns:e=\"aurora.service.exception\" xmlns:o=\"aurora.database.local.oracle\" xmlns:f=\"aurora.database.features\" alias=\"t1\" baseTable=\"" + table.getName() + "\">\n" +
                "    <bm:fields>\r\n");
        for (DBColumn s : columns) {
//            if (columnNames.contains(s.getName())) {
            sb.append("        <bm:field name=\""
                    + s.getName().toLowerCase()
                    + "\" databaseType=\""
                    + s.getJdbcType().toUpperCase()
                    + "\" datatype=\""
                    + s.getDataType()
                    + "\" physicalName=\""
                    + s.getName().toUpperCase() + "\" prompt=\""
                    + table.getName().toUpperCase() + "." + s.getName().toUpperCase() + "\"/>\r\n");
//            }
        }
        sb.append("    </bm:fields>\n" +
                "    <bm:features>\n" +
                "        <f:standard-who xmlns:f=\"aurora.database.features\"/>\n" +
                "    </bm:features>\n" +
                "</bm:model>");
        PrintWriter p = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file), "UTF-8"));
        p.write(sb.toString());
        p.close();
    }
}
