package com.hand.hls.hlcm.emay;

import com.hand.hls.hlcm.emay.eucp.inter.framework.dto.CustomSmsIdAndMobile;
import com.hand.hls.hlcm.emay.eucp.inter.framework.dto.CustomSmsIdAndMobileAndContent;
import com.hand.hls.hlcm.emay.eucp.inter.framework.dto.PersonalityParams;
import com.hand.hls.hlcm.emay.eucp.inter.http.v1.dto.request.*;
import com.hand.hls.hlcm.emay.eucp.inter.http.v1.dto.response.BalanceResponse;
import com.hand.hls.hlcm.emay.eucp.inter.http.v1.dto.response.MoResponse;
import com.hand.hls.hlcm.emay.eucp.inter.http.v1.dto.response.ReportResponse;
import com.hand.hls.hlcm.emay.eucp.inter.http.v1.dto.response.SmsResponse;
import com.hand.hls.hlcm.emay.util.AES;
import com.hand.hls.hlcm.emay.util.GZIPUtils;
import com.hand.hls.hlcm.emay.util.JsonHelper;
import com.hand.hls.hlcm.emay.util.http.*;
import jodd.util.PropertiesUtil;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Example {
    private static Logger logger = LoggerFactory.getLogger(Example.class);

    // @Value("${emay.appId:EUCP-EMY-SMS0-JBZOQ}")
    private String appId;
    // @Value("${emay.secretKey:3E6BA3366DCF8959}")
    private String secretKey;
    // @Value("${emay.host}")
    private String host;

    public static void main(String[] args) {

        // appId
        // String appId = "EUCP-EMY-SMS0-JBQNM";// 请联系销售，或者在页面中 获取
        // // 密钥
        // Stri ng secretKey = "9ACAFA95F9AE2DEE";// 请联系销售，或者在页面中 获取
        // // 接口地址
        // String host = "bjmtn.b2m.cn:80";// 请联系销售获取
        // // 加密算法
        // String algorithm = "AES/ECB/PKCS5Padding";
        // // 编码
        // String encode = "UTF-8";
        // 是否压缩
        boolean isGizp = false;

        // appId
        String appId = "EUCP-EMY-SMS0-JBZOQ";// 请联系销售，或者在页面中 获取
        // 密钥
        String secretKey = "3E6BA3366DCF8959";// 请联系销售，或者在页面中 获取
        // 接口地址
        String host = "bjmtn.b2m.cn:80";// 请联系销售获取
        // 加密算法
        String algorithm = "AES/ECB/PKCS5Padding";
        // 编码
        String encode = "UTF-8";

        // 获取余额
        // getBalance(appId, secretKey, host, algorithm, isGizp, encode);
        // // 获取状态报告
        // getReport(appId, secretKey, host, algorithm, isGizp, encode);
        // // 获取上行
        // getMo(appId, secretKey, host, algorithm, isGizp, encode);
        // // 发送单条短信
        // setSingleSms(appId, secretKey, host, algorithm, "【某某公司】您的验证码是123",
        // null, null, "12100000000", isGizp,
        // encode);//短信内容请以商务约定的为准，如果已经在通道端绑定了签名，则无需在这里添加签名
        // // // 发送批次短信[有自定义SMSID]
        // setBatchSms(appId, secretKey, host, algorithm, "【某某公司】您的验证码是123",
        // null,
        // new CustomSmsIdAndMobile[] { new CustomSmsIdAndMobile("1",
        // "12100000000"), new CustomSmsIdAndMobile("2", "12100000000") },
        // isGizp, encode);
        // // // 发送批次短信[无自定义SMSID]
        // setBatchOnlySms(appId, secretKey, host, algorithm, "【某某公司】您的验证码是123",
        // null, new String[] { "12100000000", "12100000001" }, isGizp, encode);
        // // // 发送个性短信
        // setPersonalitySms(appId, secretKey, host, algorithm, null, new
        // CustomSmsIdAndMobileAndContent[] { new
        // CustomSmsIdAndMobileAndContent("1", "12100000000",
        // "【某某公司】您的验证码是123"),
        // new CustomSmsIdAndMobileAndContent("2", "12100000001",
        // "【某某公司】您的验证码是123") }, isGizp, encode);
        // // // 发送全个性短信
        // setPersonalityAllSms(appId, secretKey, host, algorithm, new
        // PersonalityParams[] { new PersonalityParams("101", "12100000000",
        // "【天气不错0", "01", null),
        // new PersonalityParams("102", "12100000001", "天气不错1", "02", null) },
        // isGizp, encode);
        Example example = new Example();
        String a = example.setSingleSms("Testsms", "18225695917");//18225695917
    }


    /**
     * 获取余额
     *
     * @param isGzip 是否压缩
     */
    private static void getBalance(String appId, String secretKey, String host, String algorithm, boolean isGzip,
                                   String encode) {
        System.out.println("=============begin getBalance==================");
        BalanceRequest pamars = new BalanceRequest();
        ResultModel result = request(appId, secretKey, algorithm, pamars, host + "/inter/getBalance", isGzip, encode);
        System.out.println("result code :" + result.getCode());
        if ("SUCCESS".equals(result.getCode())) {
            BalanceResponse response = JsonHelper.fromJson(BalanceResponse.class, result.getResult());
            if (response != null) {
                System.out.println("result data : " + response.getBalance());
            }
        }
        System.out.println("=============end getBalance==================");
    }

    /**
     * 获取状态报告
     *
     * @param isGzip 是否压缩
     */
    private static void getReport(String appId, String secretKey, String host, String algorithm, boolean isGzip,
                                  String encode) {
        System.out.println("=============begin getReport==================");
        ReportRequest pamars = new ReportRequest();
        ResultModel result = request(appId, secretKey, algorithm, pamars, host + "/inter/getReport", isGzip, encode);
        System.out.println("result code :" + result.getCode());
        if ("SUCCESS".equals(result.getCode())) {
            ReportResponse[] response = JsonHelper.fromJson(ReportResponse[].class, result.getResult());
            if (response != null) {
                for (ReportResponse d : response) {
                    System.out.println("result data : " + d.getExtendedCode() + "," + d.getMobile() + ","
                            + d.getCustomSmsId() + "," + d.getSmsId() + "," + d.getState() + "," + d.getDesc() + ","
                            + d.getSubmitTime() + "," + d.getReceiveTime());
                }
            }
        }
        System.out.println("=============end getReport==================");
    }

    /**
     * 获取上行
     *
     * @param isGzip 是否压缩
     */
    private static void getMo(String appId, String secretKey, String host, String algorithm, boolean isGzip,
                              String encode) {
        System.out.println("=============begin getMo==================");
        MoRequest pamars = new MoRequest();
        ResultModel result = request(appId, secretKey, algorithm, pamars, host + "/inter/getMo", isGzip, encode);
        System.out.println("result code :" + result.getCode());
        if ("SUCCESS".equals(result.getCode())) {
            MoResponse[] response = JsonHelper.fromJson(MoResponse[].class, result.getResult());
            if (response != null) {
                for (MoResponse d : response) {
                    System.out.println("result data:" + d.getContent() + "," + d.getExtendedCode() + "," + d.getMobile()
                            + "," + d.getMoTime());
                }
            }
        }
        System.out.println("=============end getMo==================");
    }

    /**
     * 发送批次短信
     *
     * @param isGzip 是否压缩
     */
    private static void setBatchOnlySms(String appId, String secretKey, String host, String algorithm, String content,
                                        String extendCode, String[] mobiles, boolean isGzip, String encode) {
        System.out.println("=============begin setBatchOnlySms==================");
        SmsBatchOnlyRequest pamars = new SmsBatchOnlyRequest();
        pamars.setMobiles(mobiles);
        pamars.setExtendedCode(extendCode);
        pamars.setContent(content);
        ResultModel result = request(appId, secretKey, algorithm, pamars, host + "/inter/sendBatchOnlySMS", isGzip,
                encode);
        System.out.println("result code :" + result.getCode());
        if ("SUCCESS".equals(result.getCode())) {
            SmsResponse[] response = JsonHelper.fromJson(SmsResponse[].class, result.getResult());
            if (response != null) {
                for (SmsResponse d : response) {
                    System.out.println("data:" + d.getMobile() + "," + d.getSmsId() + "," + d.getCustomSmsId());
                }
            }
        }
        System.out.println("=============end setBatchOnlySms==================");
    }

    /**
     * 发送批次短信
     *
     * @param isGzip 是否压缩
     */
    private static void setBatchSms(String appId, String secretKey, String host, String algorithm, String content,
                                    String extendCode, CustomSmsIdAndMobile[] customSmsIdAndMobiles, boolean isGzip, String encode) {
        System.out.println("=============begin setBatchSms==================");
        SmsBatchRequest pamars = new SmsBatchRequest();
        pamars.setSmses(customSmsIdAndMobiles);
        pamars.setExtendedCode(extendCode);
        pamars.setContent(content);
        ResultModel result = request(appId, secretKey, algorithm, pamars, host + "/inter/sendBatchSMS", isGzip, encode);
        System.out.println("result code :" + result.getCode());
        if ("SUCCESS".equals(result.getCode())) {
            SmsResponse[] response = JsonHelper.fromJson(SmsResponse[].class, result.getResult());
            if (response != null) {
                for (SmsResponse d : response) {
                    System.out.println("data:" + d.getMobile() + "," + d.getSmsId() + "," + d.getCustomSmsId());
                }
            }
        }
        System.out.println("=============end setBatchSms==================");
    }

    /**
     * 发送个性短信
     *
     * @param isGzip 是否压缩
     */
    private static void setPersonalitySms(String appId, String secretKey, String host, String algorithm,
                                          String extendCode, CustomSmsIdAndMobileAndContent[] customSmsIdAndMobileAndContents, boolean isGzip,
                                          String encode) {
        System.out.println("=============begin setPersonalitySms==================");
        SmsPersonalityRequest pamars = new SmsPersonalityRequest();
        pamars.setSmses(customSmsIdAndMobileAndContents);
        pamars.setExtendedCode(extendCode);
        ResultModel result = request(appId, secretKey, algorithm, pamars, host + "/inter/sendPersonalitySMS", isGzip,
                encode);
        System.out.println("result code :" + result.getCode());
        if ("SUCCESS".equals(result.getCode())) {
            SmsResponse[] response = JsonHelper.fromJson(SmsResponse[].class, result.getResult());
            if (response != null) {
                for (SmsResponse d : response) {
                    System.out.println("data:" + d.getMobile() + "," + d.getSmsId() + "," + d.getCustomSmsId());
                }
            }
        }
        System.out.println("=============end setPersonalitySms==================");
    }

    /**
     * 发送个性短信
     *
     * @param isGzip 是否压缩
     */
    private static void setPersonalityAllSms(String appId, String secretKey, String host, String algorithm,
                                             PersonalityParams[] customSmsIdAndMobileAndContents, boolean isGzip, String encode) {
        System.out.println("=============begin setPersonalityAllSms==================");
        SmsPersonalityAllRequest pamars = new SmsPersonalityAllRequest();
        pamars.setSmses(customSmsIdAndMobileAndContents);
        ResultModel result = request(appId, secretKey, algorithm, pamars, host + "/inter/sendPersonalityAllSMS", isGzip,
                encode);
        System.out.println("result code :" + result.getCode());
        if ("SUCCESS".equals(result.getCode())) {
            SmsResponse[] response = JsonHelper.fromJson(SmsResponse[].class, result.getResult());
            if (response != null) {
                for (SmsResponse d : response) {
                    System.out.println("data:" + d.getMobile() + "," + d.getSmsId() + "," + d.getCustomSmsId());
                }
            }
        }
        System.out.println("=============end setPersonalityAllSms==================");
    }

    /**
     * 公共请求方法
     */
    public static ResultModel request(String appId, String secretKey, String algorithm, Object content, String url,
                                      final boolean isGzip, String encode) {
        Map<String, String> headers = new HashMap<String, String>();
        HttpRequest<byte[]> request = null;
        try {
            headers.put("appId", appId);
            headers.put("encode", encode);
            String requestJson = JsonHelper.toJsonString(content);
            byte[] bytes = requestJson.getBytes(encode);
            if (isGzip) {
                headers.put("gzip", "on");
                bytes = GZIPUtils.compress(bytes);
            }
            byte[] parambytes = AES.encrypt(bytes, secretKey.getBytes(), algorithm);
            HttpRequestParams<byte[]> params = new HttpRequestParams<byte[]>();
            params.setCharSet("UTF-8");
            params.setMethod("POST");
            params.setHeaders(headers);
            params.setParams(parambytes);
            params.setUrl(url);
            if (url.startsWith("https://")) {
                request = new HttpsRequestBytes(params, null);
            } else {
                request = new HttpRequestBytes(params);
            }
        } catch (Exception e) {
            logger.error("加密异常", e);
        }
        HttpClient client = new HttpClient();
        String code = null;
        String result = null;
        try {
            HttpResponseBytes res = client.service(request, new HttpResponseBytesPraser());
            if (res == null) {
                logger.info("请求接口异常");
                code = "FAIL";
                result = "请求接口异常";
                return new ResultModel(code, result);
            }
            if (res.getResultCode().equals(HttpResultCode.SUCCESS)) {
                if (res.getHttpCode() == 200) {
                    code = res.getHeaders().get("result");
                    if (code.equals("SUCCESS")) {
                        byte[] data = res.getResult();
                        data = AES.decrypt(data, secretKey.getBytes(), algorithm);
                        if (isGzip) {
                            data = GZIPUtils.decompress(data);
                        }
                        result = new String(data, encode);
                        logger.info("response json: " + result);
                    } else {
                        code = "FAIL";
                        result = res.getHeaders().get("result");
                    }
                } else {
                    logger.error("请求接口异常,请求码:" + res.getHttpCode());
                    code = "FAIL";
                    result = "请求接口异常";
                }
            } else {
                logger.error("请求接口网络异常:" + res.getResultCode().getCode());
                code = "FAIL";
                result = "请求接口异常";
            }
        } catch (Exception e) {
            logger.error("解析失败", e);
            code = "FAIL";
            result = e.getMessage();
        }
        ResultModel re = new ResultModel(code, result);
        return re;
    }

    public String setSingleSms(String content, String mobile) {
        JSONObject jsonObject = new JSONObject();

        try {
            Properties properties = new Properties();
            InputStream is = PropertiesUtil.class.getClassLoader()
                    .getResourceAsStream("config.properties");
            properties.load(is);
            appId = properties.getProperty("emay.appId");
            secretKey = properties.getProperty("emay.secretKey");
            host = properties.getProperty("emay.host");
        } catch (Exception e) {
            logger.error("读取配置文件失败", e);
            jsonObject.put("code","FALSE");
            jsonObject.put("result", "get config error");
        }

        logger.info("=============begin setSingleSms==================");
        logger.info("=============appid==================" + appId);
        SmsSingleRequest pamars = new SmsSingleRequest();
        pamars.setContent(content);
        // pamars.setCustomSmsId("1");
        // pamars.setExtendedCode(extendCode);
        pamars.setMobile(mobile);
        ResultModel result = request(appId, secretKey, "AES/ECB/PKCS5Padding", pamars,
                "http://" + host + "/inter/sendSingleSMS", false, "UTF-8");
//        if ("SUCCESS".equals(result.getCode())) {
//            SmsResponse response = JsonHelper.fromJson(SmsResponse.class, result.getResult());
//            if (response != null) {
//                logger.info("data : " + result.getCode() + "," + response.getMobile() + "," + response.getSmsId()
//                        + "," + response.getCustomSmsId());
//            }
//        }
        jsonObject.put("code", result.getCode());
        jsonObject.put("result", result.getResult());
        logger.info(jsonObject.toString());
        return jsonObject.toString();
//		if ("SUCCESS".equals(result.getCode())) {
//			return "SUCCESS";
//		} else {
//			return "FAIL";
//		}
    }

}
