package com.hand.hls.hlcm.acr.mapper;

import com.hand.hap.mybatis.common.Mapper;
import com.hand.hls.hlcm.acr.dto.AcrEleInvoiceHd;
import com.hand.hls.hlcm.acr.dto.AcrInvoiceHd;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @Author Robert8900
 * @Date: 2018/8/29 16:03
 * @Description: 电子发票中间头表mapper
 * @Purpose:
 **/
public interface AcrEleInvoiceHdMapper extends Mapper<AcrEleInvoiceHd> {
    //获取流水号
    String getSwnoDocumentNumber(@Param("userId") Long userId, @Param("companyId") Long companyId);
    //获取bpClass
    String getBpClass(@Param("bpId") Long bpId);
    //获取cellPhone
    String getCellPhone(@Param("bpId") Long bpId);
    //获取email
    String getEmail(@Param("bpId") Long bpId);
    //获取用户名称
    String getName(@Param("userId") Long userId);

    List<Map> getContractDetail(@Param("cashflowId") Long cashflowId);

    List<AcrEleInvoiceHd> getAcrEleHdInfo(AcrEleInvoiceHd acrEleInvoiceHd);

    void updateAcrEleHdStatus(@Param("invoiceHdId") Long invoiceHdId);

    void updateAceEleHdInfo(@Param("swno") String swno,@Param("fpdm") String fpdm,@Param("fphm") String fphm,@Param("pdfUrl") String pdfUrl);

    Long getEleInvoiceHdId(@Param("swno") String swno);

    String getTaxClassNum(AcrEleInvoiceHd acrEleInvoiceHd);

    void updateAceEleNumber(AcrEleInvoiceHd acrEleInvoiceHd);

    void updateAcrEleHdErrorStatus(AcrEleInvoiceHd acrEleInvoiceHd);

    void updateInvoiceHdErrorStatus(AcrInvoiceHd acrInvoiceHd);

    void deleteData(@Param("eleInvoiceHdId") Long eleInvoiceHdId);
}
