/**
 * Copyright (C) Hand Business Consulting Services
 * AllRights Reserved
 *
 * @Auther: Xianfei Zhu
 * @Date: 2018-09-10 12:16
 * @Description:
 */


package com.hand.hls.hlcm.jinsui.util;

import net.sf.json.JSONObject;


public class GetMakInvXmlUtil {

    /**
     * @param jsonString
     * @return String
     * @description 金税纸质发票开票xml报文组装
     */
    public static String getXml(String jsonString) {

        // 转换为json对象
        JSONObject jsonObject = JSONObject.fromObject(jsonString);

        StringBuilder stringBuilder = new StringBuilder();
        //报文 header 命名空间
        stringBuilder.append("<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:EjinsuiIntf-IEjinsui\">\n");
        stringBuilder.append("<soapenv:Header/>");


        stringBuilder.append("<soapenv:Body>\n");
        stringBuilder.append("<urn:MakeInv soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n");

        //报文详细内容
        stringBuilder.append("<Vjson xsi:type=\"xsd:string\">");
        stringBuilder.append(jsonObject);
        stringBuilder.append(" </Vjson>\n");

        //报文 footer 命名空间结束
        stringBuilder.append("</urn:MakeInv>\n");
        stringBuilder.append("</soapenv:Body>\n");
        stringBuilder.append("</soapenv:Envelope>");

        return stringBuilder.toString();
    }


}