package com.hand.hls.hlcm.util.acr;

import jodd.util.PropertiesUtil;

import java.io.InputStream;
import java.util.Properties;

/**
 * @Author Robert8900
 * @Date: 2018/9/6 10:48
 * @Description:
 * @Purpose:
 **/
public class GetKpylXmlUtil {
    public static String getXml(){
        String saleTax = "";
        try {
            Properties properties = new Properties();
            InputStream is = PropertiesUtil.class.getClassLoader()
                    .getResourceAsStream("config.properties");
            properties.load(is);
            saleTax = properties.getProperty("acr.saleTax");
        }catch (Exception e){
            e.printStackTrace();
        }

        StringBuilder stringBuilder = new StringBuilder();
        //报文 header 命名空间
        stringBuilder.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://service.ejinshui.com/\">\n");
        stringBuilder.append("<soapenv:Header/>\n");
        stringBuilder.append("<soapenv:Body>\n");
        stringBuilder.append("<ser:getKPYL>");

        //报文格式
        stringBuilder.append("<arg0><![CDATA[<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        stringBuilder.append("<InvoInfo>");

        //报文详细内容
        //销方税号
        stringBuilder.append("<saleTax>");
        stringBuilder.append(saleTax);
        stringBuilder.append("</saleTax>");

        //格式结束
        stringBuilder.append("</InvoInfo>]]></arg0>");

        //报文 footer 命名空间结束
        stringBuilder.append("</ser:getKPYL>\n");
        stringBuilder.append("</soapenv:Body>\n");
        stringBuilder.append("</soapenv:Envelope>");

        return stringBuilder.toString();
    }
}
