package com.hand.hls.hlcm.util;

import net.sf.json.JSONObject;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;
import java.io.File;
import java.util.Properties;

/**
 * @purpose java 邮件发送
 * @author stone
 */
public class MailSend {
    private static final Logger logger = LoggerFactory.getLogger(MailSend.class);
    private static boolean ATTACHMENT_FLAG = false;
    private static final  String CONTENT_TYPE_HTML = "text/html";
    private static final  String YES = "Y";

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }

    public String sendMain(String jsonData) {
        JSONObject jsonObject = JSONObject.fromObject(jsonData);
        JSONObject js = new JSONObject();
        // 发件人电子邮箱
        String from = jsonObject.optString("serverAddress");
//获取系统属性，主要用于设置邮件相关的参数。
        Properties properties = System.getProperties();
        //smtp协议地址
        properties.setProperty("mail.smtp.host", jsonObject.optString("serverHost"));
        //端口号
        properties.setProperty("mail.smtp.port", jsonObject.optString("serverPort"));
        properties.setProperty("mail.smtp.starttls.enable", "true");
        properties.setProperty("mail.smtp.socketFactory.fallback", "true");
        properties.setProperty("mail.smtp.auth", "true");
        //发送者账号密码
        Session session = Session.getDefaultInstance(properties, new Authenticator() {
            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(jsonObject.optString("serverName"), jsonObject.optString("serverPassWord"));
            }

        });

//创建MimeMessage消息对象，消息头配置了收发邮箱的地址，消息体包含了邮件标题和邮件内容。接收者类型：TO代表直接发送，CC代表抄送，BCC代表秘密抄送。
        try {
            MimeMessage message = new MimeMessage(session);
            message.addHeader("X-Mailer", "Microsoft Outlook Express 6.00.2900.2869");
            message.setFrom(new InternetAddress(from,"建机系统","utf-8"));
            //如果含有分号则去掉
            //收件人可能有多个
            String[] toParams = jsonObject.optString("toAddress").split(";");
            String attchFlag=jsonObject.optString("attch_flag");
            if(isNotEmpty(attchFlag)&&YES.equals(attchFlag)){
                ATTACHMENT_FLAG=true;
            }
            if (toParams.length > 0) {
                InternetAddress[] sendTo = new InternetAddress[toParams.length];
                for (int i = 0; i < toParams.length; i++) {
                    sendTo[i] = new InternetAddress(toParams[i]);
                }
                message.addRecipients(Message.RecipientType.TO, sendTo);
            }

            if (isNotEmpty(jsonObject.optString("toCcAddress"))) {
                String[] params = jsonObject.optString("toCcAddress").split(";");
                if (params.length > 0) {
                    InternetAddress[] sendCc = new InternetAddress[params.length];
                    for (int i = 0; i < params.length; i++) {
                        sendCc[i] = new InternetAddress(params[i]);
                    }
                    message.addRecipients(MimeMessage.RecipientType.CC, sendCc);
                }
            }
            message.setSubject(jsonObject.optString("toSubject"));
            Multipart multipart = new MimeMultipart();
            // 创建消息部分
            BodyPart messageBodyPart = new MimeBodyPart();
            // 消息
            String body=jsonObject.optString("toBody");
            // 创建多重消息
            // 设置文本消息部分
            //判断是html格式还是文本格式
//            if (CONTENT_TYPE_HTML.equals(jsonObject.optString("content_type"))) {
//                //删除html标签
//                body=DelHtmlScript.delHtmlTag(body);
//            }
            messageBodyPart.setText(body);

            multipart.addBodyPart(messageBodyPart);
            if(isNotEmpty(attchFlag)&&YES.equals(attchFlag)){
                String fileName=jsonObject.optString("attch_file_name");
                String filePath=jsonObject.optString("attch_file_path");
                // 附件部分
                BodyPart attachmentBodyPart = new MimeBodyPart();
                // 设置要发送附件的文件路径
                DataSource source = new FileDataSource(new File(filePath));
                attachmentBodyPart.setDataHandler(new DataHandler(source));
                // 处理附件名称中文（附带文件路径）乱码问题
                attachmentBodyPart.setFileName(MimeUtility.encodeText(fileName));
                multipart.addBodyPart(attachmentBodyPart);
            }
            message.setContent(multipart);
            Transport.send(message);
            logger.info("send Success!");
            js.put("status", 'S');
        } catch (Exception e) {
            logger.error("send Error!", e);
            js.put("status", 'E');
            js.put("errorMsg", e.getMessage());
        }
        return js.toString();
    }

   @Test
    public void test() {
        MailSend mailSend = new MailSend();
        JSONObject jb = new JSONObject();
        jb.put("serverHost", "smtp.partner.outlook.cn");
        jb.put("serverPort", "587");
        jb.put("serverName", "kenki_system@hongling.sh.cn");
        jb.put("serverPassWord", "KenkiSYS2019");
        jb.put("serverAddress", "kenki_system@hongling.sh.cn");
        jb.put("toAddress", "1174795617@qq.com");
        jb.put("toCcAddress", "");
        jb.put("toSubject", "123");
        jb.put("toBody", "<span style=\"white-space:nowrap;\">复制测试最后一百年</span>");
        jb.put("content_type", "text/html");
        jb.put("attch_flag", "Y");
        jb.put("attch_file_name", "财务收支一览表.xlsx");
        jb.put("attch_file_path", "D:/u01/hls_file/task_excel/excel1589481201751.xlsx");
        try{
            mailSend.sendMain(jb.toString());
        }catch(Exception e){
            e.printStackTrace();
        }
    }

}
