package com.hand.hls.hlcm.icbc.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hls.hlcm.icbc.dto.InterfaceRecord;
import com.hand.hls.hlcm.icbc.exception.IcbcException;
import com.hand.hls.hlcm.icbc.formbean.IcbcRd;
import com.hand.hls.hlcm.icbc.formbean.SendCommand;
import com.hand.hls.hlcm.icbc.mapper.EbankWithholdDetailMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @program: hlap-dr-parent
 * @description: ${description}
 * @author: huangtianyang
 * @create: 2018-12-20 18:39
 **/
@Service("interfaceWithHoldRecordServiceImpl")
public class InterfaceWithHoldRecordServiceImpl extends InterfaceRecordServiceImpl {
    private Logger logger = LoggerFactory.getLogger(getClass());
    private String SIGN_SUCCESS = "0";

    @Autowired
    private EbankWithholdDetailMapper detailMapper;

    @Override
    public void saveSubmitReqData(IRequest iRequest, String reqData, SendCommand sendCommand) throws DocumentException, IcbcException {
        Document document = DocumentHelper.parseText(StringUtils.trim(reqData));
        List<Element> retCodes = document.selectNodes("//pub/RetCode");
        List<Element> retMsgs = document.selectNodes("//pub/RetMsg");
        List<Element> tranDates = document.selectNodes("//pub/TranDate");
        List<Element> tranTimes = document.selectNodes("//pub/TranTime");
        List<Element> fSeqnos = document.selectNodes("//pub/fSeqno");
        List<Element> serialNos = document.selectNodes("//pub/SerialNo");


        if (CollectionUtils.isEmpty(retCodes) ||
                CollectionUtils.isEmpty(retMsgs)) {
            throw new IcbcException("invalid response: " + reqData);
        }
        if (SIGN_SUCCESS.equals(retCodes.get(0).getTextTrim())) {
            logger.debug("CODE: {}", retCodes.get(0).getTextTrim());
            logger.debug("MESSAGE: {}", retMsgs.get(0).getTextTrim());
            //保存开始 0_0
            InterfaceRecord interfaceRecord = new InterfaceRecord();
            interfaceRecord.setTranDate(getText(tranDates));
            interfaceRecord.setTranTime(getText(tranTimes));
            interfaceRecord.setfSeqno(getText(fSeqnos));
            interfaceRecord.setSerialNo(getText(serialNos));
            interfaceRecord.setBatchId(sendCommand.getBatchId());
            InterfaceRecord result = self().insertSelective(iRequest, interfaceRecord);

            List<IcbcRd> rds = sendCommand.getIcbcIn().getRds();
            if (CollectionUtils.isNotEmpty(rds)) {
                Long interfaceId = result.getInterfaceId();
                for (IcbcRd rd : rds) {
                    Long detailId = Long.valueOf(rd.getiSeqno());
                    detailMapper.updateBankDetailInterface(interfaceId, detailId);
                }
            }

        } else {
            throw new IcbcException("submit failed: CODE:" + retCodes.get(0).getTextTrim() +
                    ";MESSAGE:" + retMsgs.get(0).getTextTrim());
        }
    }
}
