package com.hand.hls.hlcm.util.acr;

import com.hand.hls.hlcm.acr.dto.AcrEleInvoiceHd;
import com.hand.hls.hlcm.acr.dto.AcrEleInvoiceLn;
import com.hand.hls.hlcm.acr.dto.AcrInvoiceHd;
import com.hand.hls.hlcm.acr.mapper.AcrEleInvoiceHdMapper;
import com.hand.hls.hlcm.acr.mapper.AcrEleInvoiceLnMapper;


import java.text.SimpleDateFormat;
import java.util.List;

/**
 * @Author Robert8900
 * @Date: 2018/8/27 11:21
 * @Description: 金税接口电子发票 开具接口 封装报文工具类
 * @Purpose:
 **/
public class AcrInfoSubmitXmlUtil {
    //封装报文
    public static String getXml(AcrInvoiceHd acrInvoiceHd,AcrEleInvoiceHdMapper acrEleInvoiceHdMapper,AcrEleInvoiceLnMapper acrEleInvoiceLnMapper){
        StringBuilder stringBuilder = new StringBuilder();
        //报文 header 命名空间
        stringBuilder.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://service.ejinshui.com/\">\n");
        stringBuilder.append("<soapenv:Header/>\n");
        stringBuilder.append("<soapenv:Body>\n");
        stringBuilder.append("<ser:submitEInvoiceInfo>");
        //报文格式
        stringBuilder.append("<arg0><![CDATA[<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        stringBuilder.append("<InvoInfo>");

        //头表信息(通过发票头表ID 找电子发票头表 只有一条)
        AcrEleInvoiceHd hd = new AcrEleInvoiceHd();
        hd.setInvoiceHdId(acrInvoiceHd.getInvoiceHdId());
        List<AcrEleInvoiceHd> acrEleInvoiceHds = acrEleInvoiceHdMapper.getAcrEleHdInfo(hd);
        AcrEleInvoiceHd acrEleInvoiceHd = acrEleInvoiceHds.get(0);
        //报文详细内容
        //流水号
        stringBuilder.append("<swno>");
        stringBuilder.append(acrEleInvoiceHd.getSwno());
        stringBuilder.append("</swno>");
        //销方税号
        stringBuilder.append("<saleTax>");
        stringBuilder.append(acrEleInvoiceHd.getSaleTax());
        stringBuilder.append("</saleTax>");
        //购方名称
        stringBuilder.append("<custName>");
        stringBuilder.append(acrEleInvoiceHd.getCustName());
        stringBuilder.append("</custName>");
        //购方税号
        stringBuilder.append("<custTaxNo>");
        if("".equals(acrEleInvoiceHd.getCustTaxNo()) || acrEleInvoiceHd.getCustTaxNo() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getCustTaxNo());
        }
        stringBuilder.append("</custTaxNo>");
        //购方地址
        stringBuilder.append("<custAddr>");
        if("".equals(acrEleInvoiceHd.getCustAddr()) || acrEleInvoiceHd.getCustAddr() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getCustAddr());
        }
        stringBuilder.append("</custAddr>");
        //购货方手机号
        stringBuilder.append("<custTelephone>");
        if("".equals(acrEleInvoiceHd.getCustTelephone()) || acrEleInvoiceHd.getCustTelephone() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getCustTelephone());
        }
        stringBuilder.append("</custTelephone>");
        //购方固定电话
        stringBuilder.append("<custPhone>");
        if("".equals(acrEleInvoiceHd.getCustPhone()) || acrEleInvoiceHd.getCustPhone() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getCustPhone());
        }
        stringBuilder.append("</custPhone>");
        //购方邮箱
        stringBuilder.append("<custEmail>");
        if("".equals(acrEleInvoiceHd.getCustEmail()) || acrEleInvoiceHd.getCustEmail() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getCustEmail());
        }
        stringBuilder.append("</custEmail>");
        //开户行+账号
        stringBuilder.append("<custBankAccount>");
        if("".equals(acrEleInvoiceHd.getCustBankAccount()) || acrEleInvoiceHd.getCustBankAccount() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getCustBankAccount());
        }
        stringBuilder.append("</custBankAccount>");
        //购货方企业类型
        stringBuilder.append("<custType>");
        stringBuilder.append(acrEleInvoiceHd.getCustType());
        stringBuilder.append("</custType>");
        //备注
        stringBuilder.append("<invoMemo>");
        if("".equals(acrEleInvoiceHd.getInvoMemo()) || acrEleInvoiceHd.getInvoMemo() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getInvoMemo());
        }
        stringBuilder.append("</invoMemo>");
        //发票类型
        stringBuilder.append("<invType>");
        stringBuilder.append(acrEleInvoiceHd.getInvType());
        stringBuilder.append("</invType>");
        //单据日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date;
        try {
            date = sdf.format(acrEleInvoiceHd.getBillDate());
            stringBuilder.append("<billDate>");
            stringBuilder.append(date);
            stringBuilder.append("</billDate>");
        }catch (Exception e){
            e.printStackTrace();
        }
        //退货单号
        stringBuilder.append("<thdh>");
        if("".equals(acrEleInvoiceHd.getThdh()) || acrEleInvoiceHd.getThdh() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getThdh());
        }
        stringBuilder.append("</thdh>");
        //开票类型 1代表正票
        stringBuilder.append("<billType>");
        stringBuilder.append(acrEleInvoiceHd.getBillType());
        stringBuilder.append("</billType>");
        //特殊冲红标志
        stringBuilder.append("<specialRedFlag>");
        stringBuilder.append(acrEleInvoiceHd.getSpecialRedFlag());
        stringBuilder.append("</specialRedFlag>");
        //操作代码
        stringBuilder.append("<operationCode>");
        stringBuilder.append(acrEleInvoiceHd.getOperationCode());
        stringBuilder.append("</operationCode>");
        //开票员
        stringBuilder.append("<kpy>");
        stringBuilder.append(acrEleInvoiceHd.getKpy());
        stringBuilder.append("</kpy>");
        //收款员
        stringBuilder.append("<sky>");
        if("".equals(acrEleInvoiceHd.getSky()) || acrEleInvoiceHd.getSky() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getSky());
        }
        stringBuilder.append("</sky>");
        //复核人
        stringBuilder.append("<fhr>");
        if("".equals(acrEleInvoiceHd.getFhr()) || acrEleInvoiceHd.getFhr() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getFhr());
        }
        stringBuilder.append("</fhr>");
        //原发票代码
        stringBuilder.append("<yfpdm>");
        if("".equals(acrEleInvoiceHd.getYfpdm()) || acrEleInvoiceHd.getYfpdm() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getYfpdm());
        }
        stringBuilder.append("</yfpdm>");
        //原发票号码
        stringBuilder.append("<yfphm>");
        if("".equals(acrEleInvoiceHd.getYfphm()) || acrEleInvoiceHd.getYfphm() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getYfphm());
        }
        stringBuilder.append("</yfphm>");
        //冲红原因
        stringBuilder.append("<chyy>");
        if("".equals(acrEleInvoiceHd.getChyy()) || acrEleInvoiceHd.getChyy() == null){
            stringBuilder.append("");
        }else{
            stringBuilder.append(acrEleInvoiceHd.getChyy());
        }
        stringBuilder.append("</chyy>");

        //行表信息
        stringBuilder.append("<Orders>");
        stringBuilder.append("<Order>");

        List<AcrEleInvoiceLn> acrEleInvoiceLns = acrEleInvoiceLnMapper.getAcrEleLnInfo(acrEleInvoiceHd.getEleInvoiceHdId());
        //订单号
        // (因为之前存行表的时候，取的是合同编号，所以虽然发票行信息不一致，
        // 但是它们都是同一个合同，所以合同编号随便取一条数据的都OK)
        stringBuilder.append("<billNo>");
        stringBuilder.append(acrEleInvoiceLns.get(0).getBillNo());
        stringBuilder.append("</billNo>");

        stringBuilder.append("<Items>");

        //根据行信息来判断是否多条
        for(int i=0;i<acrEleInvoiceLns.size();i++){
            AcrEleInvoiceLn acrEleInvoiceLn = acrEleInvoiceLns.get(i);
            stringBuilder.append("<item>");
            //商品名称
            stringBuilder.append("<name>");
            stringBuilder.append(acrEleInvoiceLn.getName());
            stringBuilder.append("</name>");
            //商品编号（税收 分类编码）
            stringBuilder.append("<code>");
            stringBuilder.append(acrEleInvoiceLn.getCode());
            stringBuilder.append("</code>");
            //发票行性质  0代表正常行
            stringBuilder.append("<lineType>");
            stringBuilder.append(acrEleInvoiceLn.getLineType());
            stringBuilder.append("</lineType>");
            //规格型号
            stringBuilder.append("<spec>");
            if("".equals(acrEleInvoiceLn.getSpec()) || acrEleInvoiceLn.getSpec() == null){
                stringBuilder.append("");
            }else{
                stringBuilder.append(acrEleInvoiceLn.getSpec());
            }
            stringBuilder.append("</spec>");
            //计量单位
            stringBuilder.append("<unit>");
            stringBuilder.append(acrEleInvoiceLn.getUnit());
            stringBuilder.append("</unit>");
            //税率
            stringBuilder.append("<taxRate>");
            stringBuilder.append(acrEleInvoiceLn.getTaxRate());
            stringBuilder.append("</taxRate>");
            //数量
            stringBuilder.append("<quantity>");
            stringBuilder.append(acrEleInvoiceLn.getQuantity());
            stringBuilder.append("</quantity>");
            //单价
            stringBuilder.append("<taxPrice>");
            stringBuilder.append(acrEleInvoiceLn.getTaxPrice());
            stringBuilder.append("</taxPrice>");
            //含税金额
            stringBuilder.append("<totalAmount>");
            stringBuilder.append(acrEleInvoiceLn.getTotalAmount());
            stringBuilder.append("</totalAmount>");
            //税收优惠政策 标志
            stringBuilder.append("<yhzcbs>");
            stringBuilder.append(acrEleInvoiceLn.getYhzcbs());
            stringBuilder.append("</yhzcbs>");
            //享受税收优惠 政策内容
            stringBuilder.append("<yhzcnr>");
            if("".equals(acrEleInvoiceLn.getYhzcnr()) || acrEleInvoiceLn.getYhzcnr() == null){
                stringBuilder.append("");
            }else{
                stringBuilder.append(acrEleInvoiceLn.getYhzcnr());
            }
            stringBuilder.append("</yhzcnr>");
            //零税率标识  空表示非0税率
            stringBuilder.append("<lslbs>");
            if("".equals(acrEleInvoiceLn.getLslbs()) || acrEleInvoiceLn.getLslbs() == null){
                stringBuilder.append("");
            }else{
                stringBuilder.append(acrEleInvoiceLn.getLslbs());
            }
            stringBuilder.append("</lslbs>");
            //自行编码
            stringBuilder.append("<zxbm>");
            if("".equals(acrEleInvoiceLn.getZxbm()) || acrEleInvoiceLn.getZxbm() == null){
                stringBuilder.append("");
            }else{
                stringBuilder.append(acrEleInvoiceLn.getZxbm());
            }
            stringBuilder.append("</zxbm>");
            //扣除额
            stringBuilder.append("<kce>");
            if("".equals(acrEleInvoiceLn.getKce()) || acrEleInvoiceLn.getKce() == null){
                stringBuilder.append("");
            }else{
                stringBuilder.append(acrEleInvoiceLn.getKce());
            }
            stringBuilder.append("</kce>");

            stringBuilder.append("</item>");
        }
        stringBuilder.append("</Items>");
        stringBuilder.append("</Order>");
        stringBuilder.append("</Orders>");

        //格式结束
        stringBuilder.append("</InvoInfo>]]></arg0>");

        //报文 footer 命名空间结束
        stringBuilder.append("</ser:submitEInvoiceInfo>\n");
        stringBuilder.append("</soapenv:Body>\n");
        stringBuilder.append("</soapenv:Envelope>");

        return stringBuilder.toString();
    }
}
