package com.hand.hls.hlcm.sys.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.hls.hlcm.sys.mapper.SysNoticeMsgDoosanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.hand.hls.hlcm.sys.dto.SysNoticeMsgDoosan;
import com.hand.hls.hlcm.sys.service.ISysNoticeMsgDoosanService;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
@Transactional(rollbackFor = Exception.class)
public class SysNoticeMsgDoosanServiceImpl extends BaseServiceImpl<SysNoticeMsgDoosan> implements ISysNoticeMsgDoosanService {

    @Autowired
    private SysNoticeMsgDoosanMapper noticeMsgMapper;

    @Override
    public int insertNotice(IRequest iRequest, SysNoticeMsgDoosan noticeMsg) {
        if (noticeMsg.getStartDateActive() == null) {
            noticeMsg.setStartDateActive(new Date());
        }
        return noticeMsgMapper.insertNotice(noticeMsg);
    }
}