-- Create table
create table ACR_INVOICE_BATCH_LN
(
  invoice_batch_ln_id      NUMBER not null,
  invoice_hd_id            NUMBER not null,
  line_type                VARCHAR2(30) not null,
  line_number              NUMBER,
  cashflow_id              NUMBER,
  cf_item                  NUMBER,
  cf_type                  NUMBER,
  product_id               NUMBER,
  product_name             VARCHAR2(2000),
  specification            VARCHAR2(2000),
  quantity                 NUMBER,
  uom                      VARCHAR2(30),
  price                    NUMBER,
  price_quantity           NUMBER,
  price_quantity_uom       VARCHAR2(30),
  net_price                NUMBER,
  tax_type_id              NUMBER,
  tax_type_rate            NUMBER,
  tax_included_flag        VARCHAR2(1),
  tax_amount               NUMBER,
  net_amount               NUMBER,
  total_amount             NUMBER,
  responsibility_center_id NUMBER,
  account_id               NUMBER,
  description              VARCHAR2(1000),
  ref_v01                  VARCHAR2(2000),
  ref_v02                  VARCHAR2(2000),
  ref_v03                  VARCHAR2(2000),
  ref_v04                  VARCHAR2(2000),
  ref_v05                  VARCHAR2(2000),
  ref_v06                  VARCHAR2(2000),
  ref_v07                  VARCHAR2(2000),
  ref_v08                  VARCHAR2(2000),
  ref_v09                  VARCHAR2(2000),
  ref_v10                  VARCHAR2(2000),
  ref_n01                  NUMBER,
  ref_n02                  NUMBER,
  ref_n03                  NUMBER,
  ref_n04                  NUMBER,
  ref_n05                  NUMBER,
  ref_n06                  NUMBER,
  ref_n07                  NUMBER,
  ref_n08                  NUMBER,
  ref_n09                  NUMBER,
  ref_n10                  NUMBER,
  ref_d01                  DATE,
  ref_d02                  DATE,
  ref_d03                  DATE,
  ref_d04                  DATE,
  ref_d05                  DATE,
  created_by               NUMBER,
  creation_date            DATE,
  last_updated_by          NUMBER,
  last_update_date         DATE,
  lease_channel            VARCHAR2(30)
);

-- Add comments to the table
comment on table ACR_INVOICE_BATCH_LN
  is '应收发票行(行合并)';
-- Add comments to the columns
comment on column ACR_INVOICE_BATCH_LN.invoice_batch_ln_id
  is '发票行ID';
comment on column ACR_INVOICE_BATCH_LN.invoice_hd_id
  is '发票ID';
comment on column ACR_INVOICE_BATCH_LN.line_type
  is '行类型';
comment on column ACR_INVOICE_BATCH_LN.line_number
  is '行号';
comment on column ACR_INVOICE_BATCH_LN.cashflow_id
  is '现金流ID';
comment on column ACR_INVOICE_BATCH_LN.cf_item
  is '现金流项目';
comment on column ACR_INVOICE_BATCH_LN.cf_type
  is '现金流类型';
comment on column ACR_INVOICE_BATCH_LN.product_id
  is '商品ID';
comment on column ACR_INVOICE_BATCH_LN.product_name
  is '商品名称';
comment on column ACR_INVOICE_BATCH_LN.specification
  is '规格型号';
comment on column ACR_INVOICE_BATCH_LN.quantity
  is '数量';
comment on column ACR_INVOICE_BATCH_LN.uom
  is '计量单位';
comment on column ACR_INVOICE_BATCH_LN.price
  is '单价（金税能算就不使用）';
comment on column ACR_INVOICE_BATCH_LN.price_quantity
  is '价格数量（暂不需要）';
comment on column ACR_INVOICE_BATCH_LN.price_quantity_uom
  is '价格数量单位（暂不需要）';
comment on column ACR_INVOICE_BATCH_LN.net_price
  is '税前单价';
comment on column ACR_INVOICE_BATCH_LN.tax_type_id
  is '税种';
comment on column ACR_INVOICE_BATCH_LN.tax_type_rate
  is '税率';
comment on column ACR_INVOICE_BATCH_LN.tax_included_flag
  is '含税标志';
comment on column ACR_INVOICE_BATCH_LN.tax_amount
  is '税额';
comment on column ACR_INVOICE_BATCH_LN.net_amount
  is '税前金额';
comment on column ACR_INVOICE_BATCH_LN.total_amount
  is '含税金额';
comment on column ACR_INVOICE_BATCH_LN.responsibility_center_id
  is '责任中心';
comment on column ACR_INVOICE_BATCH_LN.account_id
  is '科目';
comment on column ACR_INVOICE_BATCH_LN.description
  is '行备注/行摘要';
comment on column ACR_INVOICE_BATCH_LN.created_by
  is '创建者';
comment on column ACR_INVOICE_BATCH_LN.creation_date
  is '创建日期';
comment on column ACR_INVOICE_BATCH_LN.last_updated_by
  is '最后更新者';
comment on column ACR_INVOICE_BATCH_LN.last_update_date
  is '最后更新日期';
comment on column ACR_INVOICE_BATCH_LN.lease_channel
  is '商业模式';
alter table ACR_INVOICE_BATCH_LN
  add constraint ACR_INVOICE_BATCH_LN_PK primary key (INVOICE_BATCH_LN_ID);
CREATE SEQUENCE ACR_INVOICE_BATCH_LN_s;