package com.hand.hls.hlcm.cont.util;

/**
 * @Author: Liyuan.Chen
 * @Date: 2020/8/19
 * @Purpose:
 */
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.math.BigDecimal;
import java.math.BigInteger;

public class ExcelFormatUtil {
    /**
     * 设置报表头样式
     * @param workbook
     * @return
     */
    public static CellStyle headSytle(SXSSFWorkbook workbook){
        CellStyle style1 = workbook.createCellStyle();
        Font font1 = workbook.createFont();
        font1.setBold(true);
        font1.setFontHeightInPoints((short) 16);
        font1.setFontName("黑体");
        style1.setFont(font1);
        style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.CENTER);
        style1.setVerticalAlignment(VerticalAlignment.CENTER);
        return style1;
    }
    /**
     * 设置报表体样式
     * @param wb
     * @return
     */
    // 黑体加粗居左显示
    public static CellStyle contentBpStyle(SXSSFWorkbook wb){
        CellStyle style1 = wb.createCellStyle();
        Font font1 = wb.createFont();
        font1.setBold(true);
        font1.setFontName("黑体");
        style1.setFont(font1);
        //style1.setBorderBottom(BorderStyle.THIN);
        style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.LEFT);
        style1.setVerticalAlignment(VerticalAlignment.CENTER);
        return style1;
    }
    // 黑体居左显示
    public static CellStyle contentStyle(SXSSFWorkbook wb){
        CellStyle style1 = wb.createCellStyle();
        Font font1 = wb.createFont();
        font1.setFontName("黑体");
        style1.setFont(font1);
        //style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.LEFT);
        style1.setVerticalAlignment(VerticalAlignment.CENTER);
        return style1;
    }
    // 黑体居中显示
    public static CellStyle contentCenterStyle(SXSSFWorkbook wb){
        CellStyle style1 = wb.createCellStyle();
        Font font1 = wb.createFont();
        font1.setFontName("黑体");
        style1.setFont(font1);
        style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.CENTER);
        style1.setVerticalAlignment(VerticalAlignment.CENTER);
        return style1;
    }
    // 黑体加下边框线显示
    public static CellStyle contentStyleLine(SXSSFWorkbook wb){
        CellStyle style1 = wb.createCellStyle();
        Font font1 = wb.createFont();
        font1.setFontName("黑体");
        style1.setFont(font1);
        style1.setBorderBottom(BorderStyle.THIN);
        //style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.LEFT);
        style1.setVerticalAlignment(VerticalAlignment.CENTER);
        return style1;
    }
    // 列表维持原等线字体
    public static CellStyle contentTableStyle(SXSSFWorkbook wb){
        CellStyle style1 = wb.createCellStyle();
        Font font1 = wb.createFont();
        font1.setFontName("等线");
        style1.setFont(font1);
        style1.setBorderBottom(BorderStyle.THIN);
        style1.setBorderLeft(BorderStyle.THIN);
        style1.setBorderRight(BorderStyle.THIN);
        style1.setBorderTop(BorderStyle.THIN);
        style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.CENTER);
        style1.setVerticalAlignment(VerticalAlignment.CENTER);
        return style1;
    }


    /**
     *设置表头
     * @param sheet
     */
    public static void initTitle(SXSSFSheet sheet, CellStyle header, String title, int firstRow, int firstrCol) {

        SXSSFRow row = sheet.createRow(firstRow);
        SXSSFCell cell = row.createCell(firstrCol);
        //设置每一列的字段名
        cell.setCellValue(title);
        cell.setCellStyle(header);
        CellRangeAddress region = new CellRangeAddress(firstRow, firstRow+1, firstrCol, 9);
        sheet.addMergedRegion(region);
    }



    public static void initContent(SXSSFSheet sheet, CellStyle contentType, String content, int firstRow, int firstrCol) {

        SXSSFRow row = sheet.createRow(firstRow);
        SXSSFCell cell = row.createCell(firstrCol);
        //设置每一列的字段名
        cell.setCellValue(content);
        cell.setCellStyle(contentType);
        CellRangeAddress region = new CellRangeAddress(firstRow, firstRow, firstrCol, 9);
        sheet.addMergedRegion(region);
    }


    public static void initColumn(SXSSFSheet sheet, CellStyle contentTable,String title[],int titleLength[], int firstRow) {

        SXSSFRow row = sheet.createRow(firstRow);
        for(int j = 1;j<=title.length; j++) {
            SXSSFCell cell = row.createCell(j);
            //设置每一列的字段名
            cell.setCellValue(title[j-1]);
            cell.setCellStyle(contentTable);
            sheet.setColumnWidth(j, titleLength[j-1]);
        }
    }

    public static BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal) value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String) value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger) value);
            } else if (value instanceof Number) {
                ret = new BigDecimal(((Number) value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }
}
