package com.hand.hls.hlcm.txtftp.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.txtftp.service.PosTxtUploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

@Controller
public class PosTxtUploadController extends BaseController {

    @Autowired
    PosTxtUploadService posTxtUploadService;
    /**
     * 中行 pos 机 txt 导入 银行流水
     */
    @RequestMapping(value = "/pos/txt/upload")
    @ResponseBody
    public ResponseData upload(@RequestParam("CONTENT")MultipartFile file , HttpServletRequest request) throws IOException {
        ResponseData responseData = new ResponseData();
        if(file.isEmpty()){
            return null;
        }
        IRequest requestContext = createRequestContext(request);
        responseData = posTxtUploadService.createTransactionByPosTxt(requestContext,file);
        return responseData;
    }


}