package com.hand.kinggrid;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class ContractSignaturesNew
{
    public static String hl_contract_signatures(String file_path, String sign_path, Object[] param,String server_url,String app_id,String app_security)
            throws IOException, NoSuchAlgorithmException
    {
        String contractid = UUID.randomUUID().toString().replaceAll("-", "");

        HttpRequest request = MainRequest.createHttpRequest("/api/cnt/sign",server_url,app_id,app_security);
        InputStream is = null;
        String status;
        String signer_info;
        try
        {
            File file = new File(file_path);

            request.addFile("pdf_file", file);

            request.addParam("contract_name", "合同名称");
            request.addParam("contract_id", contractid);
            request.addParam("biz_id",
                    UUID.randomUUID().toString().replaceAll("-", ""));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            request.addParam("biz_time", sdf.format(new Date()));

            for(int i=0;i<param.length;i++){
                signer_info = param[i].toString();
                request.addParam("signer_info", signer_info);
            }

            /*
             * if (qf_flag.equalsIgnoreCase("Y")) { request.addParam( "signer_info",
             * "[{code:\"hlrzzl\",seal_code:\"9295f56b09124d508079b85f4a1e7e19\",seal_width:151,fontname:\"����\",fontsize:\"50\",fontcolor:\"#FF00FF\",pageno:\"0\",text:\"��ͬӡ��λ��\",qfzstart:\"1\",qfzdistance:\"200\"}]"
             * ); } else { request.addParam( "signer_info",
             * "[{code:\"hlrzzl\",seal_code:\"9295f56b09124d508079b85f4a1e7e19\",seal_width:151,fontname:\"����\",fontsize:\"50\",fontcolor:\"#FF00FF\",pageno:\"0\",text:\"��ͬӡ��λ��\"}]"
             * ); }
             *
             * if (org_flag.equalsIgnoreCase("Y")) { request.addParam( "signer_info",
             * "[{code:\"hlrzzl\",seal_code:\"fdd2f48507cb460fb372be3af2551a71\",seal_width:151,fontname:\"����\",fontsize:\"50\",fontcolor:\"#FF00FF\",pageno:\"0\",text:\"����ӡ��λ��\"}]"
             * ); }
             */

            request.send();
            JSONObject json = JSONObject.parseObject(request.resultToString());
            if (json.getInteger("code").intValue() == 1)
            {
                ContractWithTemplate.downFiles(
                        json.getJSONArray("record_saved_urls"),
                        file_path,
                        server_url,
                        app_id,
                        app_security);

                status = "SUCCESS";
            } else {
                status = "FAILURE";
            }
        }
        finally
        {
            if (is != null) {
                is.close();
            }
        }
        return status;
    }
}