## 一、项目开发规范
1. 所有的项目文件必须采用UTF-8编码，IDEA及Eclipse需要手动设置项目编码以及编译编码。  
> - Eclipse中修改项目编码的方法参考：[Eclipse修改编码方法](http://jingyan.baidu.com/article/647f0115b0c9887f2148a822.html)  
> - IDEA中修改项目编码的方法参考：[IDEA修改编码方法](http://jingyan.baidu.com/article/948f5924e4de57d80ff5f998.html])    

2. 提供他人使用的接口，原则上不允许修改**方法签名**，若是不再推荐使用，可以加**@ Deprecated**注解，同时提示新的接口名称。  
3. **DTO**类中所有的字段，不允许设置**默认值**，且DTO必须**重写toString()方法**。  
4. 原则上不允许使用递归，部分情况可以使用尾递归。  
5. 代码中不允许出现魔法值，即未定义的任何常量。  错误的用法不限于以下形式：  
```java  
if(user.getStatus() == 5){
    // 5即为魔法值，应当避免使用
    // do something
}
```  

6. 在类中定义的常量、变量及方法，需要严格控制访问修饰符，提供自己使用的设为private，可以供别人使用的可以设为public、protected等。  
7. 所有的覆写方法，必须加@Override注解，防止错误的拼写导致意外。  

--- ---  

## 二、命名规范
1. 所有的命名不允许使用**拼音或者拼音英文混合**方式，但部分公认的拼音允许使用，如**shanghai,beijing**等。  
2. 所有的命名不允许使用**下划线_**或者**美元符$**作为起始或者结束。错误的情况有不限于以下几种:  

> - **_param**
> - **$param**
> - **param_**
> - **param$**
> - **_param$**

### 包命名规范
1. 包名一般为域名倒叙开头，后接项目名，再加上单数形式的名词（项目中一般使用模块代码），且全部为小写字母，如： 
> - 系统功能模块：**com.hand.hls.sys**  
> - 合同功能模块：**com.hand.hls.cont**  

2. 在功能模块包中一般包含如下几种形式的包：  
> - 存放SpringMVC的控制层代码： **controllers**
> - 存放该模块数据库实体对象： **dto**
> - 存放该模块的部分组件： **components**
> - 存放该模块的业务接口： **service**
> - 存放改模块的业务实现类： **service.impl**
> - 存放该模块的Mybatis数据库交互层代码： **mapper**
> - 存放该模块的工具类代码： **utils**
> - 存放自定义的异常类代码： **exception**

### 类命名规范
1. 一般类名采用Pascal命名法，所有单词的首字母大写，其余字母小写，单词与单词之间不使用**下划线_**分割，常见形式如：  
> - **HlsClassName**
> - **HlsNormalClass**

2. 数据库实体类一般与数据表名称相同并改为Pascal命名规则，以**DTO**结尾，如：  
> - **SysUserDTO**
> - **SysRoleDTO**

3. 抽象类命名使用**Abstract**开头，接口一般以 **I** 开头，Mybatis的mapper对象可不用 **I** 开头但必须使用**Mapper**结尾，如： 
> - **AbstractClass**
> - **ILog**
> - **SysUserMapper**

4. 业务逻辑层接口类使用 **I** 开头，且必须以**Service**结尾；业务的实现类在接口的基础上去掉开头的字母 **I**，最后加上**Impl**，如： 
> - **ISysUserService**
> - **SysUserServiceImpl**

5. 自定义的异常类以**Exception**结尾,如：  
> - **UserNotFoundException**
> - **UserDefineException**

6. 项目中的测试类一般以测试对象的类名开头，以**Test**结尾，如：  
> - **SysUserServiceImplTest**

7. 若是采用了设计模式的类，在命名时，可在最后添加设计模式的名称，如： 
> - 工厂模式： **LoggerFactory**
> - 代理模式： **UserProxy**
> - 适配器模式： **ArrayAdapter**

### 变量命名规范
1. 成员变量、局部变量都统一使用lowerCamelCase风格，必须遵从驼峰形式,即**首单词**字母都小写，后面单词的**首字母大写**。如   
+ **hlsClassFieldName**  
+ **hlsLocalParamName**

2. 数据库对象的成员变量中若是变量的类型为Boolean类型，则变量名不允许使用 **is**开头,错误的命名如下：  
> - **private Boolean isAdmin**

### 常量命名规范
1. 常量的命名一般所有单词都**大写**，各个单词之间使用下划线`_`分隔,如：  
> - **PI**
> - **PROJECT_PATH**

2. 常量的命名尽量使用单词表达出常量的用途及含义，力求语义清晰,不用担心名字太长,如： 
> - 周期的第一天：**FIRST_DAY_OF_CYCLE**
> - 用户允许的最大错误次数：**USER_ALLOWED_MAX_ERROR_COUNT**

### 方法命名规范
1. 方法的命名规则采用lowerCamelCase风格,方法名的首单词字母全部小写，其余单词首字母大写,如：  
> - **walkMyWay()**
> - **doSomething()**

2. 对数据库进行查询的方法，一般以**select、find、query**开头,后面接查询的对象，若是查询结果为List集合，对象名可变为复数，如：  
> - `public SysUser selectSysUser()`
> - `public List<SysRole> findSysRoles()`

3. 对数据进行数据插入的方法，一般以**insert**开头，后接插入的对象，若是允许批量插入对象，对象名可变为复数，如：  
> - `public int insertSysUser(SysUser user)`
> - `public int insertSysRoles(List<SysRole> roles)`

4. 对数据库进行数据删除的方法，一般以**delete**开头，后接插入的对象，若是允许批量插入对象，对象名可变为复数，如：  
> - `public int deleteSysUser(SysUser user)`
> - `public int deleteSysRoleByIds(List<Long> roleIds)`

5. 对数据库进行数据更新的方法，一般以**update**开头，后接插入的对象，若是允许批量插入对象，对象名可变为复数，如：
> - `public SysRole updateSysRole(SysRole role)`
> - `public int updateSysUsers(List<SysUser> users)`