## HlsBarChart

```xml

    <h:hlsChart chartType="BAR" style="margin-top:5px;margin-left:6px;" barSourceData="barSourceData" titleBgColor="red"
                title="商业伙伴" modify="modifyFunc" add="addFunc" color="#ed4e2a"></h:hlsChart>
```


**常用的属性**  

| 属性名 | 类型 | 作用 | 是否必输|
|:---: | :---: | :---: | :---: | 
| id | string | 唯一标识  | 
| chartType | string | 组件类型  | Y
| style | string | 组件box样式 | 
| barSourceData | object | 组件数据源 | Y
| titleBgColor | string | 组件标题背景颜色 | 
| title | string | 组件标题 | 
| modify | function | 编辑icon触发的事件 | 
| add | function | 新增icon触发的事件 |
|color|string |字体颜色|


**下面是一个例子**


```javascript

var datas = function (url) {
        var odatas = [],
        $.ajax({
            type: 'GET',
            url: "${base.contextPath}/hls/bp/master/home/secord/query",
            async: false,
            contentType: "application/json; charset=utf-8",
            success: function (datas) {
                odatas = datas.rows; 
                
            }
        });
        return odatas;
    }(); 

var statisticalData = function () {
    var o = {};
    $.ajax({
        type: 'GET',
        url: "${base.contextPath}/hls/bp/master/count/query",
        async: false, 
        contentType: "application/json; charset=utf-8",
        success: function (datas) {
            o.allCount = datas.rows[0].allCount;
            o.monthAddCount = datas.rows[0].monthAddCount;
        }
    });
    return o;
}();



//数据源
   var barSourceData = {
        barModel: {
            xkey: 'description',
            ykeys: 'count',
            data: datas,
            labels: '数值', //鼠标经过柱子图显示的描述
            barColors: 'green',
            barSizeRatio: 0.5,
        },
        statisticalModel: {
            statisticalTitle: {
                allCount: "总数",
                monthAddCount: "本月新增"
            },
            statisticalData: statisticalData
        }
    };

    
    function modifyFunc(e) {
        alert("modifyFunc");
    }
    
    
    function addFunc(e) {
        alert("addFunc");
    }
    

```

#### 注意： 数据源中的属性名，需要固定，这样做是考虑到将不同的查询结果整合成统一的数据格式，方便组件渲染。
> - barModel:柱形图

| 属性名 | 类型 | 作用 |
|:---: | :---: | :---: | :---: | 
| xkey | string | x轴标题对应的属性名
| ykeys | string | y轴数据对应的属性名  | 
| data | Array | 数据集 |
| labels | string | 鼠标经过柱状图时ykeys对应的值的描述 | 
| barColors | string | 柱子颜色 | 
| barSizeRatio | Number | 柱子和数据的比例 | 
> - statisticalModel:上方的统计框

| 属性名 | 类型 | 作用 |
|:---: | :---: | :---: |
| statisticalTitle | object |  统计框的属性名以及属性描述 |
| statisticalData  | object |  数据源   (注意statisticalData的属性名和statisticalTitle中的属性名要对应上)




```xml
  <h:hlsChart chartType="BAR" style="margin-top:5px;margin-left:6px;" barSourceData="barSourceData" titleBgColor="red"
                title="商业伙伴" modify="modifyFunc" add="addFunc" color="#ed4e2a"></h:hlsChart>
```