## Excel文件批量导出
本系统支持Excel文件导出排队处理，支持超大数据量，能实时查询文件生成情况，支持取消导出。
#### 使用方法
1. 在代码中注入Excel导出Service
```java
@AutoWired
private ExcelExportServiceImpl excelService;
```
2. 在自己的controller中调用方法
```java
excelService.saveExportInfo(sqlId,iRequest,config,rowMaxNumber);
```

| 参数名 | 类型 | 描述 |
| :--: | :--: | :--: |
| sqlId | String | mybatis对应的数据库查询语句的ID |
| iRequest | IRequest | 带有上下文信息的reuqest对象  |
| config | ExportConfig | 包含Excel各列信息的对象，由前台传递json对象转换而来  |
| rowMaxNumber | int | 生成Excel的最大行数，可使用重载方法，不包含次参数默认为1,000,000  |

3. 运行Excel导出程序(获取该程序，请联系部门相关负责人)
```shell
java -jar hel-batch-parent.jar &
```
4. Excel导出情况查询  
用户若是为管理员身份，则查询全部人的导出情况，否则只显示当前用户的导出数据
```java
excelService.queryExportInfo(status, iRequest);
```

| 参数名 | 类型 | 描述 |
| :--: | :--: | :--: |
| status | String | 指定Excel导出的状态，该参数可为空查询全部状态数据<br><ll><li>new->等待</li><li>generating->文件导出中</li><li>finished->导出完成</li><li>failed-> 导出失败</li></ll> |
| iRequest | IRequest | 带有上下文信息的reuqest对象  |

5. 下载已完成的Excel文件
```java
excel.downloadExcel(filePath, fileName, request, response);
```

| 参数名 | 类型 | 描述 |
| :--: | :--: | :--: |
| filePath | String | 需要下载的文件的路径 |
| fileName | String | 想要保存的文件的名称  |
| request | HttpServletRequest | 用户的请求对象  |
| response | HttpServletResponse | 用户的响应对象 |

**下载前，需要检查config.properties文件中的export.offerUrl配置项是否配置正确，且为hel-batch-parent.jar提供的文件下载url**