# 消息机制

## 1.简介

融租易 的消息系统提供`唯一`和`广播`以及`主题`三种模式，实现方式为 RabbitMQ。

### 1.1 RabbitMQ介绍

RabbitMQ 是实现 AMQP（高级消息队列协议）的消息中间件的一种，用于在分布式系统中存储转发消息，在易用性、扩展性、高可用性等方面表现不俗。消息中间件主要用于组件之间的解耦。rabbitmq多应用于批量数据异步处理、并行任务串行化，高负载任务的负载均衡等 重量级，高并发，异步高可靠性场景。

### 1.2 配置rabbit

（1）用户要先在 `applicationContext-rabbitmq.xml` 中 添加`<beans:import resource="rabbitmq.xml"/>`。

（2）然后在`config.properties`中自行添加mq相关的配置如图：

![](/assets/config.png)

## 2 自定义消息

在融租易的接口管理的消息队列模块定义功中，提供了自定义队列和交换机的功能，可以根据配置实现自定义的队列和交换机的匹配，避免了在xml中的繁琐配置。

### 2.1 定义交换机

在接口管理的消息队列定义模块中，首先进行交换机的定义，界面如图：![](/assets/exchange.png)注意：

交换机名称不可以重复定义，一个交换机可以对应多个队列。

交换机类型可以分为**direct\(唯一模式\),topic\(主题模式\),fanout\(广播模式\),**rabbitmq会根据你的交换机类型和定义的路由键，完成消息的转发**。**

持久化（durable）：交换机在服务关闭后，清除与否。

自动删除（auto-delete）：当交换机没有队列绑定时，删除与否。

### 2.2 定义队列和路由键

定义完交换机后，你还需要定义你的队列和相应的匹配模式（既路由键）界面如图：![](/assets/queue.png)

注意：

队列名称不可以重复，但是一个队列可以对应多个交换机。

匹配模式（routing-key）：此处的匹配模式即为路由键

持久化（durable）：队列在服务关闭后，清除与否。

自动删除（auto-delete）：当队列没有绑定交换机时，删除与否。

私有队列（exclusive）:  仅创建者可以使用的私有队列，断开后自动删除.

## 3 发送消息/接收消息

发布订阅模式的特点是：一个消息会被所有订阅者收到（只会收到一次）。

### 3.1 发布一个消息

发布一条消息的 java 代码实例

```java
public class XXXPublisher {

 @Autowired

 private IMessagePublisher messagePublisher;



 public void publishTest (){

 // 向频道 : channel1 发布一个字符串消息

 messagePublisher.publish("channel1","message1");



 User bean = new User();

 bean.setUserName("YPP");

 // 向频道：channel2 发布一个 java bean

 messagePublisher.publish("channel2",bean);

 }

}
```

基本点，与章节 3.1 类似

1. 注入 IMessagePublisher

2. publish 方法（这个与队列不同！）

3. 支持多种类型

### 3.2 订阅一个消息

示例 java 类

```java
@TopicMonitor(channel={"channel1"})

publish class XXXSubscriber implements IMessageConsumer<String>{

 public void onMessage(String message,String pattern) {

 System.out.println("onMessage:"+message);

 }

}
```

基本点，与章节 3.2 类似

1. 添加注解 TopicMonitor，channel是一个数组，可以同时订阅多个频道，需要保证消息类型一致。

2. 实现接口 IMessageConsumer，用于接收消息

这个类需要定义为 Spring bean，或者通过注解自动扫描注册。

## 4.扩展RabbitMQ

若使用框架默认的RabbitMQ不能满足你的需求，你可以通过自定义消息队列满足你的需求。你可以在项目中新建

applicationContext-xxx.xml文件（配置如下）。

### 4.1 获取连接

通过connectionFactory获取与RabbitMQ服务器的连接。你可以再此配置所需**缓存**\(模式，大小\),**virtual-host**\(默认”\/"\)等属性

```xml
<rabbit:connection-factory id="connectionFactory" host="${rabbitmq.host}" username="${rabbitmq.username}" password="${rabbitmq.password}" port="${rabbitmq.port}"/>
```

### 4.2 队列

hap中队列根据注解动态初始化，默认队列为持久化，广播队列为非持久化。用户也可在xml通过&lt;**rabbit:queue&gt;标签**根据自身需求定义所需的队列属性如：**durable**\( 持久化属性 \),**auto-delete**\(连接关闭后是否删除队列\)**。**

```xml
<rabbit:queue name="queueTest" durable="true" auto-delete="false"></rabbit:queue>
```

### 4.3 路由

rabbitmq主要由3种路由方式**direct\(单播\),topic\(多播\),fanout\(广播\),**rabbitmq会根据使用的路由通过routing-key发送给路由里的队列。路由通过&lt;**rabbit:direct-exchange&gt;**&lt;**rabbit:** **topic-exchange&gt;**&lt;**rabbit:** **fanout-exchange&gt;标签**申明**。**

### 



