# 部署

# tomcat
<a href="#tomcat"></a>

### 1. 关闭 eclipse server `Auto Reload` 特性

  * 禁用默认值
<img src="/assets/disable_autoreload_all.png" width="50%"/>

  * 单独禁用项
<img src="/assets/disable_autoreload_1.png" width="50%"/>

* 建议关闭 jar 扫描, 提高启动速度, 减少内存占用 , 修改 `catalina.properties `

```properties
tomcat.util.scan.StandardJarScanFilter.jarsToSkip=*.jar
```

### 2. 内存设置

 * Linux  修改 `catalina.sh` ,开始处添加

    ```bash
        JAVA_OPTS='-Xms512m -Xmx2048m'
    ```
 * Windows 修改 `catalina.bat`

    ```bash
        set JAVA_OPTS=-Xms512m -Xmx2048m
    ```

### 3. 启用远程 JMX 连接

 修改 catalina.sh , 搜索 `[ "$1" = "start" ]` , 在下方添加

```bash
JAVA_OPTS="-Dcom.sun.management.jmxremote \
-Dcom.sun.management.jmxremote.port=1099 \
-Djava.rmi.server.hostname=192.168.1.111 \
-Dcom.sun.management.jmxremote.ssl=false \
-Dcom.sun.management.jmxremote.authenticate=false $JAVA_OPTS"
```

> linux 系统可以用 `` `hostname -i` `` 获取 ip

# Weblogic
<a href="#weblogic"></a>

weblogic 上的部署有些特殊，主要注意以下几点：
> **以下设置仅仅针对 weblogic 12 版本，其他版本可能存在通配符等问题**

### 1. JNDI 数据源
weblogic 上定义好数据源后，在 `config.properties` 中需要修改 jndi 的名字
```properties
db.jndiName=hap_dev
```
> tomcat 中是 java:comp/env/jdbc/hap_dev，这点不一样


### 2. 新增 weblogic.xml
在 WEB-INF 目录下新增 weblogic.xml
```bash
<?xml version="1.0" encoding="UTF-8"?>
<weblogic-web-app>
	<container-descriptor>
		<!--优先加载应用下的jar包，解决jar包冲突问题-->
		<!--具体jar包冲突问题，具体解决-->
		<prefer-application-packages>
			<package-name>org.springframework.*</package-name>
			<package-name>org.hibernate.*</package-name>
			<package-name>javax.validation.*</package-name>
			<package-name>javax.validation.spi.*</package-name>
			<package-name>org.slf4j.*</package-name>
			<package-name>com.fasterxml.*</package-name>
		</prefer-application-packages>
		<show-archived-real-path-enabled>true</show-archived-real-path-enabled>
	</container-descriptor>
</weblogic-web-app>
```

### 3. weblogic部署异常解决方案
weblogic选择要部署的war包，若出现_wl_cls_gen.jar!这样的日志异常，可将war包，直接解压，进行部署。




上述 3 点在部署的时候请留意。
