# 使用websocket实现消息提示


### 1.进行websocket的相应配置
#### 添加需要的文件
* js：webapp/lib/websocket/sockjs.js
* spring配置文件：resources/spring/applicationContext-websocket.xml

#### 配置websocket的拦截器与连接Handler



```
<bean id="websocket" class="com.hand.hap.message.websocket.DefaultWebSocketHandler"/>

    <bean class="com.hand.hap.message.websocket.WebSocketSessionManager"/>
    <bean class="com.hand.hap.message.websocket.BadgeManager"/>
    <websocket:handlers>
        <websocket:mapping path="/websocket" handler="websocket"/>
        <websocket:handshake-interceptors>
            <bean class="com.hand.hap.message.websocket.WebSocketHandshakeInterceptor"/>
        </websocket:handshake-interceptors>
        <websocket:sockjs/>
    </websocket:handlers>
```




* mapping中的path表示websocket的连接路径。
* handler是用于连接的类，必须要实现。
* interceptors可以对websocket连接进行拦截，在握手前后进行方法调用。

#### 前端打开websocket连接

```
function initWebSocket() {
            socket = new SockJS(contextPath + '/websocket');//创建SockJS对象，打开websocket连接
            socket.onmessage = function (event) {
                var data = $.parseJSON(event.data);//获取推送到前端的消息
            }
};

```


### 2.消息推送

#### 获取SocketSessionMap








