# 单点登录的简易模式
## 1、内置用于单点登录的账号
#### 菜单路径
账户管理/用户定义
#### 功能描述
用户定义的配置页面，在此处单独配置一个不过期的用户，用于单点登录时获取access_token。(任意账户均可用于access_token的获取)。

## ２、根据请求获取access_token

####注意 
  _1.参数除账号密码外不可以随意修改。
  2.如果想使用其他校验模式获取token，则需要进行额外配置。
  3.发送的请求类型必须为post请求。_
```
/oauth/token?client_id=client2&client_secret=secret&grant_type=password&username=hd001&password=1
```
#### 功能描述
根据开发的地址，以及自定义的用户，获取access_token。
#### 请求结果
如图：![](/assets/5D110915-46D6-426F-8B32-67205F989F3A.png)


## 3、进行登录
#### 登录路径

```
/hls/sso/{sourceSystem}/{username}/login?access_token=上一步获取的access_token
```

#### 功能描述
直接根据token以及username进行系统的登录，请求类型可以为post或者get类型。

#### 参数说明
* sourceSystem： 登录系统来源（任意值即可）。
* username： 登录的用户名。



## 4、配置文件
#### 配置文件路径r
resource/spring/oauth2Security.xml
#### 使用说明
如果想开发内部api用于外界访问，并根据access_token保证安全性，那么需要对配置文件进行修改。
配置如下：


```
<!--透传API Spring Security 配置-->
    <http pattern="/r/api/**"
          create-session="stateless"
          use-expressions="true"
          entry-point-ref="oauth2AuthenticationEntryPoint"
          access-decision-manager-ref="oauth2AccessDecisionManager">
        <csrf disabled="true"/>
        <!--拒绝匿名访问-->
        <anonymous enabled="true"/>
        <!-- 设置访问权限控制 -->
        <intercept-url pattern="/r/api/**" access="hasAnyRole('ROLE_USER','SCOPE_READ')"
                       method="GET"/>
        <intercept-url pattern="/r/api/**" access="hasAnyRole('ROLE_USER','SCOPE_READ')"
                       method="POST"/>
        <intercept-url pattern="/r/api/**" access="hasAnyRole('ROLE_USER','SCOPE_READ')"
                       method="PUT"/>
        <intercept-url pattern="/r/api/**" access="hasAnyRole('ROLE_USER','SCOPE_READ')"
                       method="DELETE"/>
        <!-- oauth 资源过滤器,与resource server配置对应 -->
        <custom-filter ref="apiResourceServer" before="PRE_AUTH_FILTER"/>
        <!-- 访问拒绝处理器 -->
        <access-denied-handler ref="oauth2AccessDeniedHandler"/>
    </http>
```





#### 注意
* create-session参数表示是否创建session，可以根据需求调整参数（比如单点登录的时候需要设置为ifRequired）。
* 被拦截的url需要access_token才能进行资源访问，否则会因为没有对应的权限而报错。
* 外部api不要开启csrf的配置，使用上述的失效配置即可。
* intercept-url可以进行细粒度的拦截，指定url的完整路径，以及权限控制和请求类型。


