# 跨域访问（CORS）

## 简介：

CORS需要浏览器和服务器同时支持。目前，所有浏览器都支持该功能，IE浏览器不能低于IE10。

整个CORS通信过程，都是浏览器自动完成，不需要用户参与。对于开发者来说，CORS通信与同源的AJAX通信没有差别，代码完全一样。浏览器一旦发现AJAX请求跨源，就会自动添加一些附加的头信息，有时还会多出一次附加的请求，但用户不会有感觉。

因此，实现CORS通信的关键是服务器。只要服务器实现了CORS接口，就可以跨源通信。

## 使用说明：

#### 1.修改web.xml文件：

添加Filter：

![](/assets/cors-web.png)

各参数含义：

allowedMappings: 允许跨域资源（必填）

allowedHeader:\(允许的头部参数）

allowedOrigin\(允许的请求源）

allowedMethod\(允许的请求方法\)

allowedCredentials\(是否允许携带证书）

MaxAge\(最大时长）

#### 2.发送跨域请求：

2.1 跨域登录，观察http请求response

![](/assets/cors-login.png)

2.2 登录成功所返回的信息：sessionId\(用于用户登录验证） csrf\_token（用于csrf验证）

![](/assets/cors-login1.png)

2.3  将sessionId\(Authorization\)  csrf\_\_token\(X-CSRF-\_TOKEN\)添加进requestHeader中进行后续访问

![](/assets/cors-query.png)

2.4 得到返回信息

![](/assets/cors-quer1.png)

