
# hlsCombobox标签（下拉框）

ComboBox下拉列表组件，通常数据源以code - meaning形式出现，用户操作的是meaning，实际保存的是code。

```xml

    <h:hlsCombobox name="hlsCombobox" id="hlsCombobox"
                   bind="enabled: isEnabled,source: sdDataSource, value:data.code"
                   colspan="3"
                   dataTextField="meaning"
                   dataValueField="code"
                   placeholder="hlsCombobox"
                   prompt="hlsCombobox"
                   promptColspan="1"
                   valuePrimitive="true"
                   style="width:100%"
    />
    
```

### **主要属性**
属性名    | 类型  | 说明  |
--- | ---   | --- |
id | String | id  |
promptColspan | String | 提示语句需要占几列   |
promptClassName | String | 提示语句类名，默认不填 |
promptImage | String   |  提示前面的文字图形，默认不填 |
prompt | String   |  提示信息 |
colspan | String   |  所占列数 |
hlsClassName | String | 类名，默认不填 |
dataSource | DataSource | 数据源 |
dataTextField | String | 返回的显示描述字段 |
dataValueField| String | 绑定的英文字段 |
enable | Boolean | 是否可编辑，true为可编辑，false不可编辑  | 
placeholder | String |  占位符  |
template| Function|  渲染函数 |   
change| Function |   数据变化时触发的函数  |


> 属性用法请参考KendoUI文档 [http://docs.telerik.com/kendo-ui/api/javascript/ui/combobox](http://docs.telerik.com/kendo-ui/api/javascript/ui/combobox) 


### **用法示例*

```javascript



//对于系统定义好的数据源
<script src="${base.contextPath}/common/code?sdDataSource=FND.CODING_RULE_TYPE" type="text/javascript"></script>


//自定义静态数据源sdDataSource
var sdDataSource= new kendo.data.DataSource({
    data:["one","two"]
});

//自定义动态查询到的数据源sdDataSource
$.ajax({
    type : 'GET',
    url : url,
    async: false, 
    contentType : "application/json; charset=utf-8",
    success : function(datas) {
        viewModel.set("sdDataSource,",datas.rows);
    }
});

//需要注意，bind中写dataSource，需要在viewModel中定义
var viewModel = kendo.observable({
	enabled: true,
	isEnabled: false,
	data: {},
    sdDataSource:sdDataSource, 
});

//下拉列表渲染函数
var itemTemplate = function (){
    //...
}

//选中某一个列表选项后触发
function onComboboxChange(e){
    var value = this.value();
    // Use the value of the widget.
}
//以上两种函数定义方法皆可
```

```xml
    <h:hlsCombobox name="hlsCombobox" id="hlsCombobox"
                   bind="enabled: isEnabled,source: sdDataSource, value:data.code"
                   colspan="3"
                   dataTextField="meaning"
                   dataValueField="code"
                   placeholder="hlsCombobox"
                   prompt="hlsCombobox"
                   promptColspan="1"
                   valuePrimitive="true"
                   style="width:100
                   change="onComboboxChange"
                   template="fn:itemTemplate"
                   
    />
```
#### 特别注意 valuePrimitive="true" 如果该值为false，选中的值将不会匹配给dataTextField和dataValueField
dataValueField
> **提示:** 某些属性类型为**String \| Function** 时，表明它可以定义为字符串或者函数。因此当需要定义为Function时需要增加前缀**fn:**来区分(例如函数template="fn:itemTemplate" )


