## [一、前端开发规范](id:frontEndDev)
#### 目录划分

按照web目录规范，前端文件存放在如下目录
```
  webapp  
    ├─resources
    │  ├─css
    │  ├─images
    │  ├─js
    └─WEB-INF
        ├─web.xml
        └─view

```
资源文件目录
资源文件按照类型划分为：**`resources`**

 - **`resources`**目录存放程序通用的资源文件

功能文件目录
功能文件存放在**`view`**目录下，目录的命名规则按照
> **[模块代码]**/**[功能项代码]**

例如：用户管理的功能代码是SYS001,那么用户管理相关的界面文件都存放在
```
src/main/webapp/WEB-INF/view/sys/sys001/
```

--- ---
## [二、前端命名规范](id:frontEndName)
#### 文件命名约定
界面文件按照如下格式：
>[模块代码]<u> </u>[业务对象]<u> </u>[功能操作].html

例如：用户查询界面: sys_user_query.html
#### url命名约定
对于系统中提交的url地址，按照以下格式命名
>[contextPath]/[模块代码]/[业务对象]/[操作类型]

对于常见的几种操作类型定义如下

查询URL
>[模块代码]/[业务对象]/query

批量提交  
>[模块代码]/[业务对象]/submit

批量删除
> [模块代码]/[业务对象]/remove

例如用户的查询: sys/user/query


#### 脚本变量
变量命名原则是减少变量冲突，采用Camel命名法。
>var [开发项ID]_[具体业务含义] = {}

例如：用户管理界面中用户查询的grid数据
>var d_um_002_grid = $('#d_um_002_grid').data("kendoGrid");

#### 脚本函数名
函数命名也采用Camel命名法.
>function [开发项ID]_\[具体业务含义\](){...}

例如用户查询函数
```javascript
function d_um_002_query(){
    ....
}