hlsForm表单
-----------------
 <h:hlsForm>包括两个titile部分和body部分，body通常由<h:hlsBox>和<h:hlsMaskedTextBox>、<h:hlshlsNumericTextBox>等标记组成。






#### 一般用法
```html


<!-- hlsForm子标签的使用请参见相应文档，这里不再说明-->
 <h:hlsForm title="hlsForm" width="100%">
    <h:hlsHBox>
    	<h:hlsDatePicker name="transactionDate" id="transactionDate" bind="enabled: enabled,value:data.transactionDate" colspan="4" style="width:50%" placeholder="退款日期" prompt="退款日期:" promptColspan="2" required="true"/>
        <h:hlsCombobox name="paymentMethod" id="paymentMethod" bind="enabled: enabled, source:cshPayments , value:data.paymentMethod" colspan="4" dataTextField="description" dataValueField="value" placeholder="退款方式" prompt="退款方式:" promptColspan="2" required="true" valuePrimitive="true" style="width:50%"/>			
    </h:hlsHBox>
    <h:hlsHBox>
	 <h:hlsNumericTextBox name="returnDueAmount" id="returnDueAmount" bind="enabled: enabled, value:data.returnDueAmount" style="width:50%" colspan="4" prompt="退款金额:" promptColspan="2" required="true" validationMessage="Enter {0}"/>    
 	 <h:hlsMaskedTextBox name="bankSlipNum" id="bankSlipNum"  bind="enabled: enabled, value:data.bankSlipNum" colspan="4" prompt="银行流水号:" promptColspan="2"  style="width:50%"/>    
    </h:hlsHBox>
    <h:hlsHBox>
        <h:hlsLov name="bankAccountName" id="bankAccountName" code="BANK_ACCOUNT_INFO" colspan="4" contextPath="${base.contextPath}" data-bind="enabled: enabled, value:data.bankAccountId,text:data.bankAccountName" locale="${base.locale}" placeholder="退款账户" prompt="退款账户:" promptColspan="2" query="bankAccountNameQuery" change="bankAccountNameChange" select="bankAccountNameSelect" required="true" style="width:50%" />
    	<h:hlsMaskedTextBox name="bankAccountNum" id="bankAccountNum" bind="enabled: isEnabled, value:data.bankAccountNum" colspan="4" prompt="账号:" promptColspan="2" style="width:50%" />    
     </h:hlsHBox>
</h:hlsForm>


```


### **主要属性**

| 属性名 | 类型 | 描述 |
| --- | --- | --- |
| width | String | form组件的宽度|
|hlsClassName | String |组件的类样式|
| title | String | 标题文字|

> **注意:**


```javascript
$('#query-form input').keydown(function (e) {
	    if (e.keyCode == 13) {
	        e.target.blur();
	        viewModel.queryResource(e);
	    }
});
```
>**详解：**
> - query-form 是表单id，input指表单内所有输入框 (样式选择器选到input)
> - viewModel.queryResource(e)当按下回车按钮时都执行查询方法

---------------


#### viewModel在多处出现，这里粗略的介绍一下

```

viewModel用法
Kendo MVVM是一种MVVM的实现，当然可以跟Kendo 组件(widgets)和数据源(datasource)进行无缝结合

```javascript
var viewModel = kendo.observable({
        model: {
        //model 中可设置绑定初值
            id:5
        },
        //可以自定义函数方法 :如saveFunction方法
        saveFunction: function () {
            $('#grid').data('kendoGrid').saveChanges();
        },
        queryResource: function (e) {
            $('#grid').data('kendoGrid').dataSource.page(1);
        }
    });
```

使用:（**注意data-bind**）
```html
<div id="view">
    <input data-bind="value: model.id" />
    <button data-bind="click: saveFunction">Display</button>
</div>
```
关于绑定

```html
<div id="view" data-bind="value: model.name"></div>
<script>
    var viewModel = kendo.observable({
        model: {
            name: "John Doe"
        }
    });
    kendo.bind($("#view"), viewModel);
</script>
```
> **注意:**

> - viewModel中绑定是实时的，即viewModel中的name字段发生变化，则input中的value会一起变化，反之，当input中的value值变化，则viewModel中的name字段也会一同发生变化
> - viewModel中的所有字段属性都是可自定义的
> - 绑定需要input中data-bind 和kendo-bind两次绑定 第一是将数值绑定到model上，第二次是将此div绑定到viewModel上，这样才能访问到viewModel的model属性，也就是第一次绑定才有效

重置按钮

```javascript
resetForm : function(e) {
   	 var formData = viewModel.model.toJSON();
   	 for ( var k in formData) {
   		 viewModel.model.set(k, null);
   	 }
}
```

```html
<span class="btn btn-default" data-bind="click:resetForm" type="button"><@spring.message "hap.reset"/></span>

```
> **注意:**
> - viewModel与表单绑定后，model里面的字段变化，input框里的value里一起变化，所以在清空viewModel的同时，清空了表单里的数据

